#if !defined (_CLIENT_ACCEPTOR_H)
#define _CLIENT_ACCEPTOR_H

#include "cdevSessionManager.h"

#include "cdevSocketAcceptor.h"

// *****************************************************************************
// * class ClientAcceptor:
// *	This class provdies the cdevEventHandler that accepts connections through
// *	the reactor on the listening port.  Once accepted, these new connections 
// *	are serviced by the ClientHandler.
// *****************************************************************************
class GENERIC_SERVER_API ClientAcceptor : public cdevEventHandler, public ErrorReporter
{
friend class ClientHandler;
public:
	ClientAcceptor              (cdevSessionManager &s);
	~ClientAcceptor		    (void);
	
	const char *getName         (void) { return "ClientAcceptor"; }
	int         getLocalAddress (cdevAddr &addr) { return acceptor.getLocalAddress(addr); }
	int         open            (const cdevInetAddr &addr);

	virtual int getHandle       (void) const;
	virtual int handleInput     (void);
	virtual int handleClose     (void);

private:	
	cdevSocketAcceptor   acceptor;
	cdevSessionManager & server;
};

#endif 
