#include <cdevServer.h>


// *****************************************************************************
// * class ReflectorServer :
// *	This is the server class for the reflector.  It simply receives messages
// *	from a client and immediately returns them.
// *
// *	The constructor passes the domain, server, port and rate to the
// *	underlying cdevServer class to be processed.  The cdevServer constructor
// *	will add this server to the Name Server and will begin processing 
// *	messages when the cdevServer::runServer() method is executed.
// *
// *	The processMessages method is the servers interface to the world... Each
// *	time a complete message is received or the time specified in rate
// *	expires, that method will be called.
// *****************************************************************************
class ReflectorServer : public cdevServer
{
public:
	ReflectorServer ( char * domain, char * server, unsigned int port, double pulse )
		: cdevServer(domain, server, port, pulse)
		{
		}

	virtual void processMessages ( void )
		{
		cdevMessage * message;
		while(dequeue(message)==0)
			{
			// message->asciiDump();
			enqueue(message);
			delete message;
			}
		}
};


int main()
{
ReflectorServer server("REFLECTOR", "TestServerX", 0, 60);
cdevServer::runServer();

return 0;
}
