#include <FD_Trigger.h>

char * resultString[] = 
	{
	"SUCCEEDED",
	"FAILED"
	};
	
int main ()
	{
	#ifdef _WIN32
		InitializeNetwork();
	#endif

	FD_Trigger trigger;
	int i;
	int cnt;
	int singleInsertResult = 0;
	int multiInsertResult = 0;
	int singleExtractResult = 0;
	int multiExtractResult = 0;
	int purgeResult = 0;	
	
	fprintf(stdout, "Inserting Twenty Single Events\n");
	for(i=0, cnt=0; i<20; i++)
		{
		if(trigger.insertEvent()!=0)
			{
			fprintf(stdout, "Error inserting event %i\n", i);
			singleInsertResult = 1;
			}
		else cnt++;
		}
	fprintf(stdout, "%i Events Successfully Inserted - %i Failed\n", cnt, 20-cnt);
	
	fprintf(stdout, "Extracting Each Event\n");
	for(cnt=0; trigger.removeEvent()==0 && cnt<500; cnt++);
	if(cnt!=20) singleExtractResult = 1;
	fprintf(stdout, "Extracted %i Events\n", cnt);
	
	fprintf(stdout, "Inserting Twenty Quad Events\n");
	for(i=0, cnt=0; i<20; i++)
		{
		if(trigger.insertEvent(4)!=0)
			{
			fprintf(stdout, "Error inserting event %i\n", i);
			multiInsertResult = 1;
			}
		else cnt++;
		}
	fprintf(stdout, "%i Quad Events Successfully Inserted - %i Failed\n", cnt, 20-cnt);
	
	fprintf(stdout, "Extracting Each Event\n");
	for(cnt=0; trigger.removeEvent()==0 && cnt<500; cnt++);
	if(cnt!=80) singleExtractResult = 1;
	fprintf(stdout, "Extracted %i Events\n", cnt);
	
	fprintf(stdout, "Inserting Twenty Single Events\n");
	for(i=0, cnt=0; i<20; i++)
		{
		if(trigger.insertEvent()!=0)
			{
			fprintf(stdout, "Error inserting event %i\n", i);
			singleInsertResult = 1;
			}
		else cnt++;
		}
	fprintf(stdout, "%i Events Successfully Inserted - %i Failed\n", cnt, 20-cnt);
	
	fprintf(stdout, "Extracting Each Quad Event\n");
	for(cnt=0; trigger.removeEvent(4)==0 && cnt<500; cnt++);
	if(cnt!=5) multiExtractResult = 1;
	fprintf(stdout, "Extracted %i Quad Events\n", cnt);
	
	fprintf(stdout, "Inserting Twenty Single Events\n");
	for(i=0, cnt=0; i<20; i++)
		{
		if(trigger.insertEvent()!=0)
			{
			fprintf(stdout, "Error inserting event %i\n", i);
			}
		else cnt++;
		}
	fprintf(stdout, "%i Events Successfully Inserted - %i Failed\n", cnt, 20-cnt);
	
	fprintf(stdout, "Purging Trigger\n");
	trigger.purge();
	fprintf(stdout, "Extracting Each Remaining Event\n");
	for(cnt=0; trigger.removeEvent()==0 && cnt<500; cnt++);
	if(cnt!=0) purgeResult = 1;
	fprintf(stdout, "Extracted %i Events\n\n", cnt);
	
	fprintf(stdout, "RESULTS: \n");
	fprintf(stdout, "\tInsertion of single events %s\n", resultString[singleInsertResult]);
	fprintf(stdout, "\tInsertion of multiple events %s\n", resultString[multiInsertResult]);
	fprintf(stdout, "\tExtraction of single events %s\n", resultString[singleExtractResult]);
	fprintf(stdout, "\tExtraction of multiple events %s\n", resultString[multiExtractResult]);
	fprintf(stdout, "\tPurging of multiple events %s\n", resultString[purgeResult]);
	
	#ifdef _WIN32
		TerminateNetwork();
	#endif
	return 0;
	}
