#if !defined (_CLIENT_HANDLER_H)
#define _CLIENT_HANDLER_H

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "cdevSessionManager.h"
#include "SocketUtil.h"

#include "cdevSocketStream.h"

class GENERIC_SERVER_API ClientHandler : public cdevEventHandler, public SocketReader, public SocketWriter
{
public:
	ClientHandler                           (cdevSessionManager & s);
	~ClientHandler                          (void);

	char *                     getHostName  (void);
	const    char *            getName      (void) { return "ClientHandler"; }
	virtual  int               open         (class ClientAcceptor * acc);
	virtual  int               getHandle    (void) const;
	operator cdevSocketStream &             (void) { return stream; }
	
	virtual int                handleClose     (void);
	virtual int                handleInput     (void);
	virtual int                handleOutput    (void);
	virtual int                handleExcept    (void); 

	size_t                     getPacketsSent  (void) { return packetsSent; }
	size_t                     getPacketsRecv  (void) { return packetsRecv; }
	
protected:
	char                   hostName[MAXHOSTNAMELEN + 1];
	cdevSocketStream       stream;  
	cdevSessionManager   & server;
	SocketSession        * queue;
	int                    clientQuitFlag;
	size_t                 packetsSent;
	size_t                 packetsRecv;
};

#endif /* _CLIENT_HANDLER_H */
