#ifndef _CDEV_TIME_H_
#define _CDEV_TIME_H_ 1

#include "cdevPlatforms.h"

#define ONE_SECOND 1000000

typedef struct timeval timeval;

class CDEV_REACTOR_API cdevTime 
{
private:
	long tv_sec;
	long tv_usec;
		
public:
	cdevTime  ( long sec=0, long usec=0 );
	cdevTime  ( double t );
	cdevTime  ( timeval &t );
	cdevTime  ( const cdevTime &t );
	
	void getTime ( double * t ) const;
	void getTime ( long *sec, long *usec) const;
	void getTime ( timeval * t ) const;
	
	void setTime ( void );
	void setTime ( double t );
	void setTime ( long sec, long usec);
	void setTime ( timeval &t );
	void setTime ( const cdevTime &t );
	
	void clear     ( void );
	int  isSet     ( void ) const;
	int  normalize ( void );

	operator double         ( void );
	operator timeval ( void ); 
 
	cdevTime &       operator =  (const cdevTime& t);
	
	friend cdevTime  operator +  (cdevTime t1, cdevTime t2);
	friend cdevTime  operator -  (cdevTime t1, cdevTime t2);
	friend int      operator <  (cdevTime t1, cdevTime t2);
	friend int      operator >  (cdevTime t1, cdevTime t2);  
	friend int      operator <= (cdevTime t1, cdevTime t2);
	friend int      operator >= (cdevTime t1, cdevTime t2);  
	friend int      operator == (cdevTime t1, cdevTime t2);  
	friend int      operator != (cdevTime t1, cdevTime t2);  
};

#endif
