#include "cdevTime.h"

cdevTime::cdevTime ( long sec, long usec )
	{
	setTime(sec, usec);
	}
	

cdevTime::cdevTime ( double t )
	{
	setTime(t);
	}
	

cdevTime::cdevTime ( timeval & t )
	{
	setTime(t);
	}
	

cdevTime::cdevTime ( const cdevTime & t )
	{
	setTime(t);
	}


void cdevTime::getTime ( double * t ) const
	{
	if(t) *t = (double)tv_sec+(double)tv_usec/(double)ONE_SECOND;
	}
	

void cdevTime::getTime ( long * sec, long * usec) const
	{
	if(sec && usec)	
		{
		*sec = tv_sec;
		*usec = tv_usec;
		}
	}
	

void cdevTime::getTime ( timeval * t ) const
	{
	if(t)	{
		t->tv_sec = tv_sec;
		t->tv_usec = tv_usec;
		}
	}
	

void cdevTime::setTime ( void )
	{
	struct timeval tv_time;

	gettimeofday(&tv_time);

	tv_sec  = tv_time.tv_sec;
	tv_usec = tv_time.tv_usec;
	}

	
void cdevTime::setTime ( double t )
	{
	tv_sec = (long)t;
	tv_usec = (long)((double)fmod(t, 1.0)*(double)ONE_SECOND);
	normalize();
	}


void cdevTime::setTime ( long sec, long usec )
	{
	tv_sec = sec;
	tv_usec = usec;
	normalize();
	}
	

void cdevTime::setTime ( timeval & t )
	{
	tv_sec  = t.tv_sec;
	tv_usec = t.tv_usec;
	normalize();
	}
	

void cdevTime::setTime ( const cdevTime & t )
	{
	t.getTime(&tv_sec, &tv_usec);
	normalize();
	}
	

void cdevTime::clear ( void )
	{
	tv_sec = 0;
	tv_usec = 0;
	}
	

int cdevTime::isSet ( void ) const
	{
	return (tv_sec||tv_usec)?1:0;
	}
	

int cdevTime::normalize ( void )
	{
	while ((this->tv_usec >= ONE_SECOND) 
		 || (this->tv_sec < 0 && this->tv_usec > 0 ))
		{
		this->tv_usec -= ONE_SECOND;
		this->tv_sec++;
		}

	while ((this->tv_usec <= -ONE_SECOND) 
		|| (this->tv_sec > 0 && this->tv_usec < 0))
		{
		this->tv_usec += ONE_SECOND;
		this->tv_sec--;
		}
	
	return isSet();
	}
	

cdevTime & cdevTime::operator = ( const cdevTime & t )
	{
	if (this != &t)
		{
		tv_sec = t.tv_sec;
		tv_usec = t.tv_usec;
		}
	return *this;
	}
	

cdevTime::operator double ( void )
	{
	return (double)tv_sec+(double)tv_usec/(double)ONE_SECOND;
	}
	

cdevTime::operator timeval ( void )
	{
	timeval tv_time;

	tv_time.tv_sec  = tv_sec;
	tv_time.tv_usec = tv_usec;

	return tv_time;
	}
	

cdevTime operator + (cdevTime t1, cdevTime t2)
	{
	cdevTime sum (t1.tv_sec + t2.tv_sec, t1.tv_usec + t2.tv_usec);

	sum.normalize ();
	return sum;
	}


cdevTime operator - (cdevTime t1, cdevTime t2)
	{
	cdevTime delta (t1.tv_sec - t2.tv_sec, t1.tv_usec - t2.tv_usec);

	delta.normalize ();
	return delta;
	}


int operator > (cdevTime t1, cdevTime t2)
	{
	if (t1.tv_sec > t2.tv_sec) return 1;
	else if (t1.tv_sec == t2.tv_sec && t1.tv_usec > t2.tv_usec) return 1;
	else return 0;
	}


int operator >= (cdevTime t1, cdevTime t2)
	{
	if (t1.tv_sec > t2.tv_sec) return 1;
	else if (t1.tv_sec == t2.tv_sec && t1.tv_usec >= t2.tv_usec) return 1;
	else return 0;
	}


int operator < (cdevTime t1, cdevTime t2)
	{
	return t2 > t1;
	}


int operator <= (cdevTime t1, cdevTime t2)
	{
	return t2 >= t1;
	}


int operator == (cdevTime t1, cdevTime t2)
	{
	return t1.tv_sec == t2.tv_sec && t1.tv_usec == t2.tv_usec;
	}


int operator != (cdevTime t1, cdevTime t2)
	{
	return !(t1 == t2);
	}
