#ifndef _CDEV_SOCKET_ACCEPTOR_H_
#define _CDEV_SOCKET_ACCEPTOR_H_

#include "cdevSocketStream.h"

class CDEV_REACTOR_API cdevSocketAcceptor : public cdevSocket
{
public:
	cdevSocketAcceptor(void);
	cdevSocketAcceptor(
		const cdevAddr &addr, 
		int reuse_addr = 0, 
		int protocol_family = PF_INET, 
		int backlog = 5, 
		int protocol = 0);
	
	int open(const cdevAddr &addr, 
		 int reuse_addr = 0, 
		 int protocol_family = PF_INET, 
		 int backlog = 5, 
		 int protocol = 0,
		 int reopen = 1);
	
	int accept(
		cdevSocketStream &new_stream, 
		cdevAddr *remote_addr=0) const;
	
private:
	int getRemoteAddress(cdevAddr &) const;
};

#endif 	/* _CDEV_SOCKET_ACCEPTOR_H */		
