//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      File Descriptor Mask Class (Based On ACE Handler_Set)

#ifndef _CDEV_HANDLE_SET_H_
#define _CDEV_HANDLE_SET_H_

#include <stdio.h>
#include <string.h>
#include "cdevPlatforms.h"

class CDEV_REACTOR_API cdevHandleSet
{
friend class cdevHandleSetIterator;
friend class cdevReactor;

public:
	cdevHandleSet (void);
	cdevHandleSet (const fd_set &mask);

	void reset     (void);
	int  is_set    (int) const;
	void set_bit   (int);
	void clr_bit   (int);
	int  num_set   (void) const;
	int  max_set   (void) const;
	int  asciiDump (FILE * fp = stdout);
	void sync      (int max = FD_SETSIZE);

	operator fd_set *( void ) { return &mask_; }

private:
	int	 size_;
	int	 max_handle_;
	fd_set   mask_;

	enum	{
		#ifdef _WIN32
			MAX_SIZE  = FD_SETSIZE,
		#else
			MAX_SIZE  = NOFILE,
			WORD_SIZE = NFDBITS,
			NUM_WORDS = howmany (NOFILE, NFDBITS),
			#ifdef __DECCXX
				MSB_MASK	= ~(1U << (NFDBITS - 1))
			#elif defined(CDEV_HAS_64BIT_LONGS)
				MSB_MASK	= ~(1UL << (NFDBITS - 1))
			#else
				MSB_MASK	= ~(1 << (NFDBITS - 1))
			#endif
		#endif
		};

	int  count_bits (unsigned long n) const;
	void set_max (int max);

	static const char nbits_[256];
};

class CDEV_REACTOR_API cdevHandleSetIterator
{
public:
	cdevHandleSetIterator (cdevHandleSet &);
	int  operator ()(void);
	void operator++ (void);

private:
	cdevHandleSet  &fds_;
	int	  num_;

	#ifdef _WIN32
		unsigned int index_;
	#else
		int     index_;
		fd_mask val_;
	#endif
};

#endif /* _CDEV_HANDLE_SET_H_ */
