#ifndef _CDEV_EVENT_HANDLER_H_
#define _CDEV_EVENT_HANDLER_H_ 1

#include "cdevTime.h"

class CDEV_REACTOR_API cdevEventHandler
{
friend class cdevReactor;

public:
	enum	{
		READ_MASK   = 0x01,
		EXCEPT_MASK = 0x02,
		WRITE_MASK  = 0x04,
		DONT_CALL   = 0x100
		} REACTOR_MASK;

private:
	void               setReactor     (cdevReactor * r);
	cdevEventHandler * getNext        (void );
	void               setNext        (cdevEventHandler * n);
	cdevTime &         getNextTimeout (void);

protected:
	cdevEventHandler * next;
	cdevTime           nextTimeout;
	cdevReactor      * reactor;
	cdevTime           timeoutRate;
	int                mask;
	
public:
	cdevEventHandler             ( void ); 
	virtual ~cdevEventHandler    ( void );

	virtual void             setMask        ( unsigned Mask );
	virtual void             setHandle      ( int handle );
	virtual int              getHandle      ( void ) const;
	virtual int              getMask        ( void );
	virtual cdevReactor *    getReactor     ( void );

	virtual cdevTime &       getTimeoutRate	( void );
	virtual void             setTimeoutRate ( cdevTime time );
	virtual void             resetTimer     ( void );
				
	virtual int              handleInput    ( void );
	virtual int              handleOutput   ( void );
	virtual int              handleExcept   ( void );
	virtual int              handleTimeout  ( void );
	virtual int              handleSignal   ( void );
	virtual int              handleClose    ( void );

};

#endif
