#include <cdevReactor.h>
#include <stdlib.h>
#include <stdio.h>

class simpleTimer : public cdevEventHandler 
{
private:
	char   c;

public:
	simpleTimer ( char outputChar='.', double timeout=1.0 )
		: c(outputChar)
		{
		setTimeoutRate(timeout);
		}
		
	int handleTimeout ( void )
		{
		fprintf(stdout, "%c", c);
		fflush(stdout);
		return 0;
		}
};

int main (int argc, char ** argv)
	{
	int iterations = 100;
	cdevReactor reactor;
	simpleTimer timer1('.', 1.0);
	simpleTimer timer2('-', 0.5);
	simpleTimer timer3(',', 10.0);
	simpleTimer timer4('+', 0.25);
	simpleTimer timer5('-', 0.05);
	
	if(argc>1) iterations = atoi(argv[1]);
	if(iterations<=0) iterations=100;
	
	fprintf(stdout, "Processing for %i iterations\n", iterations);

	reactor.registerTimer(&timer1);
	reactor.registerTimer(&timer2);
	reactor.registerTimer(&timer3);
	reactor.registerTimer(&timer4);
	reactor.registerTimer(&timer5);
	
	for(int i=0; i<iterations; i++) reactor.handleEvents();
	return 0;
	}
