#ifndef _SERVER_INTERFACE_H_
#define _SERVER_INTERFACE_H_

#include "cdevErrCode.h"
#include "ServerHandler.h"
#include "ErrorReporter.h"
#include "StringHash.h"
#include "fifo.h"
#include "cdevReactor.h"
#include "cdevEventHandler.h"
#include "cdevAddr.h"

class GENERIC_SERVER_API ServerConnectionList 
{
private:
	enum { ALLOCATION_COUNT = 32 };	
	ServerHandler ** items;
	int              maxItems;	

public:
	ServerConnectionList          ( void );
	virtual ~ServerConnectionList ( void );

	ServerHandler * find          ( char * server );
	int             insert        ( ServerHandler * handler );
	int             remove        ( ServerHandler * handler );
	ServerHandler * remove        ( char * server );

	ServerHandler * operator []   ( int idx ) 
		{ return (idx<maxItems)?items[idx]:(ServerHandler *)NULL; }
};


class GENERIC_SERVER_API ServerInterface : public ErrorReporter
{
protected:
	ServerConnectionList   connections;
	StringHash             connectionQueues;
	char                 * defaultServer;
	ServerHandler        * defaultServerHandler;
	int                    maxFd;
	int                  * fdList;
	
public:
	enum { FAILED_TO_SEND = -1, COMPLETED = 0};
	
	static cdevReactor      Reactor;
		
	ServerInterface                       ( void );
	~ServerInterface                      ( void );
	
	virtual char *          getDefault    ( void );
	virtual void            setDefault    ( char * Default ); 
	
	virtual ServerHandler * connect       ( char * server, char * host=NULL, unsigned short port=0 );
	virtual ServerHandler * disconnect    ( char * server );

	int                     enqueue       ( ServerHandler * handler, char * binary, size_t binaryLen );
	FifoQueue             * getQueue      ( char * server );
	virtual int             enqueue       ( int status, ServerHandler * handler, char * binary, size_t binaryLen ) = 0;
	virtual int		isPacketValid ( char * binary, size_t binaryLen );

	virtual int             getFd         ( int * &fd, int &numFd );
	virtual int             flush         ( void );
	int                     flush         ( int fd );
	virtual int             poll          ( void );
	virtual int             pend          ( double seconds, int fd = -1 );
};


#endif /* _SERVER_INTERFACE_H_ */
