//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Database (Memory) Table Definition
//
// Author:  Jie Chen
//
//   
//
//
#ifndef _RSVC_TABLE_DEF_H
#define _RSVC_TABLE_DEF_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <rsvcData.h>

//=========================================================================
//   Table Definition by a rsvcData Object
//         tag                  value
//
//         "table"              "name"
//         "key"                "name"
//         "keyExp"             "expression"
//         "keyType"            something
//         "*******"            "anything"
//         "*******"            "anything"
//=========================================================================

// currently the key can be only in the form of the following
// attr0 + attr1
// eventually I am going to use yacc to build a better function

class rsvcTableDef;

typedef int (*rsvcKeyFunc)(rsvcData& data, rsvcTableDef* table);

class rsvcTableDef
{
public:
  // constructor and destructor
  
  // create an empty table definition
  rsvcTableDef       (char* name);
  ~rsvcTableDef      (void);

  // construct table definition from a rsvcData
  int create         (rsvcData& data);
  // construct table definition from disk
  int create         (void);
  // dump table definition to disk: overwrite existing table definition
  int output         (void);
  // output table definition to a rsvcData object
  int output         (rsvcData& data);

  // is table definition set
  int tableDefined   (void) const;

  // some commonly used operations
  
  // check whether this row name is valid
  int rowNameValid   (char*   row);
  int rowValid       (char*   row, int type);
  // is this data valid: all tags must be a subset of table
  int dataValid      (rsvcData& data);
  // does this data look the same as the table?
  int dataInsertable (rsvcData& data);
  // check whether this data has key value in it
  int hasKey         (rsvcData& data);

  // get key information
  // What is the name for the key? This determines the file name
  // of the datafile
  char* keyName      (void) const;
  // What is the expression for the key? Currently the expression
  // must be one of the row name
  char* keyExp       (void) const;
  // what is the key type for the key?
  int   keyType      (void) const;

  // insert tagged key value into a data
  int   keyValue     (rsvcData& data);

  // table name
  char* name         (void) const;

protected:

  // all key calculation functions
  static             int sameAttr (rsvcData& data, rsvcTableDef* table);
  static             int attrPlus (rsvcData& data, rsvcTableDef* table);

private:
  // function for figure out real table definition file name
  // caller release returned memory
  static char*   tableDefFileName (char* tablename);

  // check whether two types are convertable or not
  static int     typeConvertable  (int type0, int type1);

  // parse simple key expression
  int            parseKeyExp      (char* exp);

  // real rsvcData object
  rsvcData       table_;
  int            defined_;

  // table name
  char*          name_;

  // key name
  char*          keyname_;

  // key exp
  char*          keyexp_;

  // key type
  int            keytype_;

  // index calculate function pointer
  rsvcKeyFunc    keyfunc_;

  // attributes that make up the key
  char* attr0_;
  char* attr1_;


  // deny copy and assignment operations
  rsvcTableDef (const rsvcTableDef& def);
  rsvcTableDef& operator = (const rsvcTableDef& def);
};
#endif

  
