//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of C++ DBT wrapper
//
// Author:  Jie Chen
//
// Revision History:
//   rsvcDBT.cc,v
// Revision 1.1  1998/01/22  17:08:03  akers
// Addition of new NameServer
//
//
//
#include "rsvcDBT.h"

rsvcDBT::rsvcDBT (void)
:dealloc_ (1)
{
#ifdef _TRACE_OBJECTS
  printf ("Create rsvcDBT Class Object\n");
#endif
  memset (&data_, 0, sizeof (DBT));
}

rsvcDBT::~rsvcDBT (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete rsvcDBT Class Object\n");
#endif
  if (data_.data && dealloc_)
    delete []data_.data;
  data_.size = 0;
}

void *
rsvcDBT::data (void) const
{
  return data_.data;
}

size_t
rsvcDBT::size (void) const
{
  return data_.size;
}

void
rsvcDBT::data (void* ptr, int dealloc)
{
  data_.data = ptr;
  dealloc_ = dealloc;
}

void
rsvcDBT::size (size_t len)
{
  data_.size = len;
}

DBT *
rsvcDBT::dbt (void)
{
  return &data_;
}

void
rsvcDBT::datacpy (void* data)
{
  memcpy (data_.data, data, data_.size);
}

