//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Configuration Header
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_CONFIG_H
#define _RSVC_CONFIG_H

#define RSVC_SERVER_PORT         10932
#define RSVC_MAX_KEY_LEN         (unsigned int)256
#define RSVC_KEY_NAME            (char *)"key"
#define RSVC_TABLE_NAME          (char *)"table"
#define RSVC_TABLE_NAME_EXT      (char *)".def"
#define RSVC_KEY_TYPE_NAME       (char *)"keyType"
#define RSVC_KEY_EXP_NAME        (char *)"keyExp"
#define RSVC_MONITOR_TAG         (char *)"monitorOn"
#define RSVC_QUERY_TAG           (char *)"query"
#define RSVC_CACHE_MAX           20         /* tuned for name server */
#define RSVC_CACHE_LF            5
#define RSVC_RLIMIT_NOFILE       256
#define RSVC_UDP_BUFFER_SIZE     4096


#define RSVC_OP_UNKNOWN          (unsigned int)2000

#define RSVC_CREATE_TABLE        (unsigned int)1000
#define RSVC_CREATE_MEMTABLE     (unsigned int)1001
#define RSVC_OPEN_DBASE          (unsigned int)1002
#define RSVC_GET                 (unsigned int)1010
#define RSVC_SET                 (unsigned int)1011
#define RSVC_DEL                 (unsigned int)1012
#define RSVC_INSERT              (unsigned int)1013
#define RSVC_OVERWRITE           (unsigned int)1014
#define RSVC_QUERY               (unsigned int)1020

#define RSVC_MONITOR_ON          (unsigned int)1500
#define RSVC_MONITOR_ONATTR      (unsigned int)1501
#define RSVC_MONITOR_OFF         (unsigned int)1600
#define RSVC_MONITOR_OFFATTR     (unsigned int)1601

#define RSVC_MONITOR_ENTRIES     (unsigned int)1650
#define RSVC_MONITOR_OFFENTRIES  (unsigned int)1651

#define RSVC_SERVER_EXIT         (unsigned int)1700

#define RSVC_DATA_IN_MEMORY      1
#define RSVC_DATA_ON_DISK        2

#include <rsvcLocalConfig.h>

#endif
