//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of rsvcCallback Class
//
// Author:  Jie Chen
//
// Revision History:
//   rsvcCallback.cc,v
// Revision 1.1  1998/01/22  17:08:00  akers
// Addition of new NameServer
//
//
//
#include "rsvcCallback.h"

rsvcCallback::rsvcCallback (void)
:cbk_ (0), arg_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("Create rsvcCallback Class Object\n");
#endif
}

rsvcCallback::rsvcCallback (rsvcCbkFunc func, void* arg)
:cbk_ (func), arg_ (arg)
{
#ifdef _TRACE_OBJECTS
  printf ("Create rsvcCallback Class Object\n");
#endif
}

rsvcCallback::rsvcCallback (const rsvcCallback& cbk)
:cbk_ (cbk.cbk_), arg_ (cbk.arg_)
{
#ifdef _TRACE_OBJECTS
  printf ("Create rsvcCallback Class Object\n");
#endif
}

rsvcCallback &
rsvcCallback::operator = (const rsvcCallback& cbk)
{
  if (this != &cbk) {
    cbk_ = cbk.cbk_;
    arg_ = cbk.arg_;
  }
  return *this;
}

rsvcCallback::~rsvcCallback (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete rsvcCallback Class Object\n");
#endif
}

int
rsvcCallback::operator == (const rsvcCallback& cbk)
{
  return (cbk_ == cbk.cbk_ && arg_ == cbk.arg_);
}

int
rsvcCallback::operator != (const rsvcCallback& cbk)
{
  return !(cbk_ == cbk.cbk_ && arg_ == cbk.arg_);
}

rsvcCbkFunc
rsvcCallback::cbkFunc (void) const
{
  return cbk_;
}

void *
rsvcCallback::userarg (void) const
{
  return arg_;
}

int
rsvcCallback::empty (void)
{
  return !cbk_;
}

