//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// Jefferson Lab HPC Group, 12000 Jefferson Ave., Newport News, VA 23606
//-----------------------------------------------------------------------------
//
// Description:
//      Data Type Of Time Stamp
//
// Author:  
//      Jie Chen
//      Jefferson Lab HPC Group
//
// Revision History:
//   $Log: rsvcTimeStamp.java,v $
//   Revision 1.1  1999/10/18 17:12:44  chen
//   *** empty log message ***
//
//
//
import java.util.Date;

public final class rsvcTimeStamp extends Number
{
    public int  secPastEpoch; // seconds since Jan. 1, 1970
    public int  nsec;         // nano seconds

    /**
     * Construct a time stamp with current time
     */
    public rsvcTimeStamp ()
    {
	Date d = new Date();
	long t = d.getTime();
	secPastEpoch = (int)(t/1000);
	nsec = (int)(t - secPastEpoch)*1000;
    }

    /**
     * Construct a time stamp with provided second and nano second fields
     */
    public rsvcTimeStamp (int sec, int nsec)
    {
	secPastEpoch = sec + nsec/1000000000;
	nsec = nsec - nsec/1000000000 * 1000000000;
    }

    // all inherited functions
    /**
     * Return byte value of time stamp
     */
    public byte byteValue ()
    {
	return (byte)secPastEpoch;
    }

    /**
     * Return short value of time stamp
     */
    public short shortValue ()
    {
	return (short)secPastEpoch;
    }

    /**
     * Return integer value of time stamp
     */
    public int intValue ()
    {
	return secPastEpoch;
    }

    /**
     * Return long value of time stamp
     */    
    public long longValue ()
    {
	return (long)secPastEpoch;
    }

    /**
     * Return float value of time stamp
     */
    public float floatValue ()
    {
	return (secPastEpoch + nsec/(float)1000000000.0);
    }

    /**
     * Return double value of time stamp
     */
    public double doubleValue ()
    {
	return (secPastEpoch + nsec/1000000000.0);
    }

    /**
     * Return string representation
     */    
    public String toString ()
    {
	Date d = new Date ((long)((long)secPastEpoch*1000));
	return d.toString();
    }
	
}
	
