import java.io.*;
import java.util.*;
import java.net.*;
import rsvcClient;
import rsvcEventHandler;
import rsvcConfig;

public final class rsvcClientTest implements rsvcEventHandler
{
    public rsvcClientTest ()
    {
	// empty
    }

    public static void main (String[] args) 
    {
	if (args.length < 4) {
	    System.err.println ("Usage: rsvcClientTest servername domain host port");
	    System.exit (-1);
	}

	rsvcClientTest test = new rsvcClientTest ();

	String host = args[2];
	int port = Integer.valueOf (args[3]).intValue();
	String server = args[0];
	String domain = args[1];
	
	rsvcClient client = new rsvcClient ();

	try {
	    client.connect (host, port);
	}catch (UnknownHostException ue) {
	    System.err.println (ue);
	    System.exit (-1);
	}catch (IOException e) {
	    System.err.println (e);
	    System.exit (-1);
	}

	// outbound event stream
	rsvcEvent oevent = null;

	rsvcData serverinfo = new rsvcData ();
	serverinfo.insert ("name", server);
	serverinfo.insert ("domain", domain);
	try {
	    oevent = client.getValue ("cdevServers", serverinfo,
				      test);
	}catch (IOException e) {
	    System.err.println (e);
	    System.exit (-1);
	}

	try {
	    oevent = client.query ("cdevServers", "all",
				   test);
	}catch (IOException e) {
	    System.err.println (e);
	    System.exit (-1);
	}

	try {
	    oevent = client.monitorValue ("cdevServers", serverinfo,
					  test);
	}catch (IOException e) {
	    System.err.println (e);
	    System.exit (-1);
	}
	
	Thread readerThread = client.getReaderThread ();
	try {
	    readerThread.join ();
	} catch (InterruptedException e) {
	    System.err.println (e);
	    System.exit (-1);
	}
    }

    public void handleEvent (rsvcEvent event)
    {
	int status = event.getStatus ();
	int opcode = event.getOpcode ();
	rsvcData data = event.getData ();

	System.out.println ("Handle event is called with status :" + String.valueOf (status));
	
	switch (opcode) {
	case rsvcConfig.RSVC_GET:
	    System.out.println ("Get Value with result :");
	    break;
	case rsvcConfig.RSVC_QUERY:
	    System.out.println ("Query Value with result :");
	    break;	    
	default:
	    System.out.println ("Operation : " + String.valueOf (opcode));
	}

	if (status == rsvcConfig.RSVC_NOTFOUND)
	    System.out.println ("Found nothing");

	if (status == rsvcConfig.RSVC_SUCCESS)
	    data.asciiDump ();
    }
}


	
	    
	
