.SUFFIXES: .cc .obj

APPNAME     = Name Server Interface for CDEV
ARCH        = WINNT-4.0

BINARIES    = $(TEMPLINKS) $(BASEBIN)\cdev_test 

include ..\..\include\makeinclude\Makefile.WINNT-4.0

TEMPLINKS = rsvcSlist.cc\
	    rsvcHSlist.cc\
	    rsvcHash.cc\
	    rsvcDataStreamer.cc\
	    rsvcDataEntry.cc\
	    rsvcData.cc\
	    rsvcNetData.cc\
	    rsvcCbk.cc\
	    rsvcHashable.cc\
	    rsvcStreamable.cc\
	    rsvcCallback.cc\
	    rsvcClient.cc\
	    rsvcUdpClient.cc 
OBJS      = $(OBJDIR)\rsvcSlist.obj\
	    $(OBJDIR)\rsvcHSlist.obj\
	    $(OBJDIR)\rsvcHash.obj\
	    $(OBJDIR)\rsvcDataStreamer.obj\
	    $(OBJDIR)\rsvcDataEntry.obj\
	    $(OBJDIR)\rsvcData.obj\
	    $(OBJDIR)\rsvcNetData.obj\
	    $(OBJDIR)\rsvcCbk.obj\
	    $(OBJDIR)\rsvcHashable.obj\
	    $(OBJDIR)\rsvcStreamable.obj\
	    $(OBJDIR)\rsvcCallback.obj\
	    $(OBJDIR)\rsvcClient.obj\
	    $(OBJDIR)\rsvcUdpClient.obj\
	    $(OBJDIR)\rnsService.obj\
	    $(OBJDIR)\rnsRequestObject.obj

!IF "$(SHOBJ)" == "YES"
TARGETS = $(TEMPLINKS) $(CDEVSHOBJ)\$(CDEVVERSION)\rnsService.dll $(BASEBIN)\cdev_test.exe 
!ELSE
TARGETS = $(TEMPLINKS) $(CDEVLIB)\rnsService.lib
!ENDIF

CXXINCLUDES  = -I.\\
CXXEXTRA_DLL   = /D "_RSVC_CORE_EXPORTS_=1"

targets : $(TARGETS)
	@erase $(TEMPLINKS)
	
$(BASEBIN)\cdev_test.exe: $(OBJDIR)\cdev_test.obj 
	-@if exist $@ erase $@
	@echo ^ ^ ^ ^ ^ ^ =^> Linking $(@F)
	$(LINK) $(CDEVLIB)\cdev.lib\
	$(LINK_EXE_FLAGS) /out:$@ $? 
	@echo ^ ^ ^ ^ ^ ^ ^ ^ ^ Done...
	
$(CDEVLIB)\rnsService.lib: $(OBJS)
	@echo ^ ^ ^ =^> Linking $(@F) 
	-@if exist $@ erase $@
	-@if not exist $(@D) mkdir $(@D)
	@$(LIB32) $(CDEVLIB)\cdev.lib\
	$(LINK_LIB_FLAGS) /out:$@ $(OBJS)
	@echo ^ ^ ^ ^ ^ ^ Done...

$(CDEVLIB)\rnsService.dll: $(OBJS)
	@echo ^ ^ ^ =^> Linking $(@F) 
	-@if exist $@ erase $@
	-@if not exist $(@D) mkdir $(@D)
	@$(LIB32) $(CDEVLIB)\cdev.lib\
	$(LINK_DLL_FLAGS) /out:$@ /implib:$(@D)\$(@B).lib $(OBJS)
	-@if not exist $(CDEVSHOBJ)\$(CDEVVERSION) mkdir $(CDEVSHOBJ)\$(CDEVVERSION)
	@copy $@ $(CDEVSHOBJ)\$(CDEVVERSION)\$(@F) > nul
	@echo ^ ^ ^ ^ ^ ^ Done...	

$(CDEVSHOBJ)\$(CDEVVERSION)\rnsService.dll : $(CDEVLIB)\rnsService.dll
	@echo ^ ^ ^ =^> Transfer $(@F) to CDEVSHOBJ directory
	-@copy $(CDEVLIB)\rnsService.dll $@

rsvcSlist.cc		: ..\src\rsvcSlist.cc 
	-@$(CREATE_LINK)
	
rsvcHSlist.cc		: ..\src\rsvcHSlist.cc 
	-@$(CREATE_LINK)
	
rsvcHash.cc		: ..\src\rsvcHash.cc 
	-@$(CREATE_LINK)
	
rsvcDataStreamer.cc	: ..\src\rsvcDataStreamer.cc 
	-@$(CREATE_LINK)
	
rsvcDataEntry.cc	: ..\src\rsvcDataEntry.cc 
	-@$(CREATE_LINK)
	
rsvcData.cc		: ..\src\rsvcData.cc 
	-@$(CREATE_LINK)
	
rsvcNetData.cc		: ..\src\rsvcNetData.cc 
	-@$(CREATE_LINK)
	
rsvcCbk.cc		: ..\src\rsvcCbk.cc 
	-@$(CREATE_LINK)
	
rsvcHashable.cc		: ..\src\rsvcHashable.cc 
	-@$(CREATE_LINK)
	
rsvcStreamable.cc	: ..\src\rsvcStreamable.cc 
	-@$(CREATE_LINK)
	
rsvcCallback.cc		: ..\src\rsvcCallback.cc 
	-@$(CREATE_LINK)
	
rsvcClient.cc		: ..\src\rsvcClient.cc 
	-@$(CREATE_LINK)
	
rsvcUdpClient.cc	: ..\src\rsvcUdpClient.cc
	-@$(CREATE_LINK)
	
