#include "SampleService.h"

cdevService * newSampleService ( char * name, cdevSystem * system )
	{
	return new SampleService(name, *system);	
	}


SampleService::SampleService ( char * name, cdevSystem & system ) 
	: cdevSimpleService(name, system), var(0)
	{
	}
	
SampleService::~SampleService ( void )
	{
	}
	
void SampleService::handleOneEvent ( void )
	{
	cdevTransaction * transaction;
	char            * device;
	char            * message;
	cdevData        * data;
	
	if(dequeue(transaction, device, message, data)==CDEV_SUCCESS)
		{
		data->insert("device", device);
		data->insert("message", message);
		data->insert("value", var++);
		enqueue(CDEV_SUCCESS, transaction, device, message, data);
		}
	}
