/*
 *-----------------------------------------------------------------------------
 * Copyright (c) 1995      Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 *-----------------------------------------------------------------------------
 *
 * Description:
 *	This header file contains the class definitions for the classes
 *	associated with the construction of a request object.
 *
 * Author:  Walt Akers
 *
 *-----------------------------------------------------------------------------
 */

#if !defined (_SCRIPT_REQUEST_OBJECT_H_)
#define _SCRIPT_REQUEST_OBJECT_H_

#include <cdevRequestObject.h>
#include <cdevTranObj.h>
#include <cdevGroup.h>
#include <cdevErrCode.h>

// *****************************************************************************
// * ScriptRequestObject:
// *	The ScriptRequestObject class provides the interface for sending 
// *	messages to a server.  All device/message commands are routed 
// *	through a ScriptRequestObject either directly or indirectly.
// *****************************************************************************
class ScriptRequestObject : public cdevRequestObject 
{
friend class ScriptService;

public:
	// *********************************************************************
	// * This is how long the system will wait for a reply to be returned
	// * from a send.
	// *********************************************************************
	enum { SEND_WAIT_PERIOD=30 };

	// *********************************************************************
	// * ScriptRequestObject::ScriptRequestObject :
	// *	This constructor initializes the internals of a device/message
	// *	pair associated with the server.
	// *
	// *	Returns nothing.
	// *********************************************************************
	ScriptRequestObject ( char * device, char * message, 
			      cdevSystem & system = cdevSystem::defaultSystem() );
			     
	// *********************************************************************
	// * ScriptRequestObject::~ScriptRequestObject :
	// *	This destructor performs any deallocation or shutdown operations
	// *	necessary, prior to the destruction of the object.
	// *
	// *	Returns nothing.
	// *********************************************************************
	virtual ~ScriptRequestObject ( void ) {}
		
	// *********************************************************************
	// * ScriptRequestObject::send : 
	// *	The send interface is used to provide synchronous I/O with the
	// *	service.
	// *
	// *	Returns CDEV_SUCCESS on success or CDEV_ERROR on error.
	// *********************************************************************
	int send ( cdevData & in, cdevData & out ) 
		{ return send(&in, &out); }
	int send ( cdevData * in, cdevData & out ) 
		{ return send(in, &out);  }
	int send ( cdevData & in, cdevData * out ) 
		{ return send(&in, out);  }
	int send ( cdevData * in, cdevData * out );

	// *********************************************************************
	// * ScriptRequestObject::sendNoBlock :
	// *	The sendNoBlock interface is used in conjunction with cdevGroup
	// *	or cdevSystem to execute a series of operations.  During the
	// *	early implementation of this product, these functions will be
	// *	linked directly to the send call.
	// *
	// *	Returns CDEV_SUCCESS on success or CDEV_ERROR on error.
	// *********************************************************************
	int sendNoBlock (cdevData & in, cdevData & out) 
		{ return sendNoBlock(&in, &out); }
	int sendNoBlock (cdevData * in, cdevData & out) 
		{ return sendNoBlock(in, &out); }
	int sendNoBlock (cdevData & in, cdevData * out) 
		{ return sendNoBlock(&in, out); }
	int sendNoBlock (cdevData * in, cdevData * out);
		
	// *********************************************************************
	// * ScriptRequestObject::sendCallback :
	// *	The sendCallback interface provides asynchronous communications
	// *	with the server. During the early implementation of this 
	// *	product, these functions will be linked directly to the send 
	// *	call.
	// *
	// *	Returns CDEV_SUCCESS on success or CDEV_ERROR on error.
	// *********************************************************************
	int sendCallback (cdevData & in, cdevCallback & callback) 
		{ return sendCallback(&in, callback); }
	int sendCallback (cdevData * in, cdevCallback & callback);
	
	// *********************************************************************
	// * ScriptRequestObject::className :
	// *	This function returns the name of the class as a constant string
	// *********************************************************************
	const char * className ( void ) const { return "ScriptRequestObject"; }

private:
	int        syncFinished;
	int        syncStatus;
	static int syncCode;
	};

#endif /* _SCRIPT_REQUEST_OBJECT_H_ */
