/*
 * -----------------------------------------------------------------------------
 * Copyright (c) 1995      Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * -----------------------------------------------------------------------------
 *
 * Description:
 *	This header file contains the class definitions for the classes
 *	associated with the construction of a script service.
 *
 * Author:  Walt Akers
 *
 * -----------------------------------------------------------------------------
 */

#include <sys/ioctl.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <cdevData.h>
#include <cdevTranObj.h>
#include <cdevSelector.h>
// *****************************************************************************
// * class ScriptData :
// *	This contains the information associated with a single script.  A list
// *	of ScriptData objects is maintained and accessed through the ScriptList 
// *	object.
// *
// *	Note: because this object is only accessed through the ScriptList 
// *	object, all data items have been made public to improve performance.
// *****************************************************************************
class ScriptData
{
public:	
	typedef struct {
		int readFD;
		int writeFD;
		} SocketPair;


	ScriptData      * next;
	SocketPair        sp;
	cdevTranObj     * xobj;
	cdevData        * data;
	char            * inputBuf;
	int               inputBufLen;
	int               amntRead;
	pid_t             process;
	int               finished;
	int               callbackCount;
			
	ScriptData  ( cdevTranObj & Xobj ); 
	~ScriptData (void);
	static int  data2Buffer      (cdevData & data, char *& buf, int &bufLen);
	static void dataArray2Buffer (char       * output, 
				      char      ** ptr, 
				      size_t     & ptrIdx, 
				      cdevBounds * bounds, 
				      size_t       nBounds, 
				      size_t       boundsIdx);
	static void dataArray2Buffer (char       * output, 
				      double     * ptr, 
				      size_t     & ptrIdx, 
				      cdevBounds * bounds, 
				      size_t       nBounds, 
				      size_t       boundsIdx);
	static int buffer2Data       (char * &buf, cdevData & data );
	void       fireCallback      (int result, 
				      void * arg, 
				      cdevRequestObject &req, 
				      cdevData & data, 
				      int partial=0);
	int        dispatch          (void);
};


// *****************************************************************************
// * class ScriptList:
// *	This class maintains a list of ScriptData objects that represent all
// *	of the scripts that are currently being run by the ScriptService.  The
// *	ScriptService object will use the methods of this object to perform 
// *	operations on the items in the list.
// * 
// *	Because this class is only accessible through the ScriptService, its
// *	internals have been made public to improve performance.
// *****************************************************************************
class ScriptList
{
public:
	static cdevSelector selector;

	ScriptData * scripts;
	int        * fdList;
	int          fdCount;
	int          fdMax;

	ScriptList  (void);
	~ScriptList (void);
	ScriptData * find   ( int fd );
	void         insert ( ScriptData & script );
	void         remove ( ScriptData & script );
	void         remove ( int fd );
	int          getFd  ( int * &fd, int & numFd );
	int          poll   ( void );
};



