#include <cdevSystem.h>
#include <cdevDirectory.h>
#include <CLIPService.h>
#include <CLIPRequestObject.h>

CLIPRequestObject::CLIPRequestObject ( char * device, char * message, cdevSystem & system)
	: cdevClientRequestObject(device, message, system)
	{
	cdevData output;
	
	*host = 0;
	port  = 0;
  	
	sprintf (host, "resolveServiceData %s %s", device, message);
  	if((system.nameServer()).send(host, NULL, &output)==CDEV_SUCCESS)
  		{
		*host = 0;
		output.get ("host", host, 256);
		output.get ("port", &port);
		}
	else *host = 0;
	}
	
int CLIPRequestObject::getServerHandler ( ServerHandler ** Handler )
	{
	CLIPService * svc     = (CLIPService *)service_;
	int           result  = CDEV_SUCCESS;
	
	*Handler = NULL;
	
	if (*server==0 && *DDL_server!=0) strcpy(server, DDL_server);
	if (*server!=0 && handler==NULL)
	  {
	    if((*Handler = svc->connect(server, 
					(*host)?host:(char *)NULL, 
					(*host)?port:0))==NULL) result = CDEV_ERROR;
		else
			{
			handler = *Handler;
			handler->registerServerCallback(this);
			}
		}
	else *Handler = handler;
			
	return result;
	}
	
