#include "cdevSelector.h"
#include <stdio.h>
#include <time.h>

#define MASK(f)     (1 << (f))
#define NUMFDS 1

void main()
{
int fd[NUMFDS];
int fdmask[NUMFDS];
int readmask = 0;
int readfds;
int nfound, i;
int count = 0;
struct timeval timeout;

cdevSelector selector;
fd[0] = selector.readfd();
selector.insertEvent(20);
selector.removeEvent(20);
selector.purge();
selector.insertEvent(50);

/* First open each terminal for reading and put the
 * file descriptors into array fd[NUMFDS].  The code
 * for opening the terminals is not shown here.
 */

for (i=0; i < NUMFDS; i++) 
	{
	fdmask[i] = MASK(fd[i]);
	readmask |= fdmask[i];
	}

timeout.tv_sec  = 0;
timeout.tv_usec = 50000;
readfds = readmask;

/* select on NUMFDS+3 file descriptors if stdin, stdout
 * and stderr are also open
 */

while((nfound = select (NUMFDS+3, &readfds, 0, 0, &timeout)) > 0) 
	{
	for (i=0; i < NUMFDS; i++)
		{
		if (fdmask[i] & readfds)
			{
			if(i==0)
				{
				selector.removeEvent();
				printf("removed %i event from the selector\n", count++);
				}
        		}
        	else printf ("fd[%d] is not ready for reading \n",i);
		}
	}
if(nfound < 0) perror ("select failed");
else if (nfound == 0) printf ("select timed out \n");
}
