//---------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//----------------------------------------------------------------------------
//
// description: cdevUtil.cc
//	A simple command line utility designed to provide a direct user
//	interface to cdevServices.  
//
// Author: Walt Akers
//
//
//--------------------------------------------------------------------------

#ifndef _CDEV_UTIL_H_
#define _CDEV_UTIL_H_ 1

// *****************************************************************************
// * class cdevCallbackArg:
// * 	This class is used to control deletion of the cdevData object passed as 
// *	an argument to the sendCallback function.  This class is passed as the 
// *	userarg element of the callback structure, and if the permanent flag is 
// *	false(0) when the callback is executed, the class and its contents will 
// *	be deleted.
// *****************************************************************************
class cdevCallbackArg
{
private:
	int          Permanent;
	cdevCallback Callback;
	cdevData     Data;

public:
	cdevCallbackArg ( cdevCallbackFunction func, int permanent = 0) 
		: Permanent(permanent), Callback(func, this) {}
	~cdevCallbackArg( void ) {}

	int          & permanent ( void ) { return Permanent; }
	cdevCallback & callback  ( void ) { return Callback; }
	cdevData     & data      ( void ) { return Data; }
};

#endif /* _CDEV_UTIL_H_ */

