//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      CDEV Skeleton request object
//
// Author:  Jie Chen
//
// Revision History:
//   skRequestObject.h,v
// Revision 1.2  1995/07/22  22:59:00  watson
// var1,var2 version
//
// Revision 1.1  1995/07/22  20:20:09  watson
// add skeleton service
//
//
#ifndef _CDEV_SK_REQUESTOBJ_H
#define _CDEV_SK_REQUESTOBJ_H

#include <cdevErrCode.h>
#include <cdevSystem.h>
#include <cdevRequestObject.h>

class CDEVSVC_CLASS_SPEC skRequestObject: public cdevRequestObject
{
 public:
  // constructor and destructor
  skRequestObject (char* device, char* msg, cdevSystem& system);
  ~skRequestObject (void);

  // IO operations
  int send (cdevData& out, cdevData& result);
  int send (cdevData* out, cdevData& result);
  int send (cdevData& out, cdevData* result);
  int send (cdevData* out, cdevData* result);

  int sendNoBlock (cdevData& out, cdevData& result);
  int sendNoBlock (cdevData* out, cdevData& result);
  int sendNoBlock (cdevData& out, cdevData* result);
  int sendNoBlock (cdevData* out, cdevData* result);

  int sendCallback (cdevData& out, cdevCallback& callback);
  int sendCallback (cdevData* out, cdevCallback& callback); 

  enum {GET = 0x3000, SET, UNKNOWN};

  const char *className (void) const {return "skRequestObject";};

 protected:
  // convert char string action msg into integer
  static int findAction (char *msg, int& action);
  static int findSvcData (char *device, char *msg, 
			  cdevSystem& system, int& ind);
  // callback functions
  static void getCallback (int status, void *arg, int result);
  static void setCallback (int status, void *arg, int result);

 private:
  int action_;
  int index_;
};

#endif
