//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdevErrReqObject class implementation. 
//
// Author:  Jie Chen & Chip Watson
//
// Revision History:
//   cdevErrReqObject.cc,v
// Revision 1.6  1998/03/09  18:51:36  chen
// redefine getState/getAccess for errReqObject
//
// Revision 1.5  1998/02/19  18:39:58  akers
// Bug Fixes
//
// Revision 1.4  1995/10/26  14:33:22  akers
// Removal of Warnings
//
// Revision 1.3  1995/10/17  20:21:23  chen
// change reportError status value
//
// Revision 1.2  1995/10/17  15:27:38  chen
// change reportError interface
//
// Revision 1.1.1.1  1995/06/16  17:14:06  epics
// initial import of cdev
//
//
#include <cdevErrCode.h>
#include "cdevErrReqObject.h"

cdevErrReqObject::cdevErrReqObject (cdevSystem& system)
:cdevRequestObject ((char *)"errHandleDevice",(char *)"errHandle", system)
{
#ifdef _TRACE_OBJECTS
  printf("         Create cdevErrReqObject class\n");
#endif
  // empty
}

cdevErrReqObject::~cdevErrReqObject (void)
{
#ifdef _TRACE_OBJECTS
  printf("         Delete cdevErrReqObject class\n");
#endif
  system_.errorRequestObject (0);
}

int
cdevErrReqObject::send (cdevData& out, cdevData& result)
{
  return send (&out, &result);
}

int
cdevErrReqObject::send (cdevData& out, cdevData* result)
{
  return send (&out, result);
}

int
cdevErrReqObject::send (cdevData* out, cdevData& result)
{
  return send (out, &result);
}

int
cdevErrReqObject::send (cdevData* , cdevData* )
{
  system_.reportError (CDEV_SEVERITY_ERROR, system_.name(), 
		       this, "Attempt to send with an invalid request object.");
  return CDEV_INVALIDOBJ;
}

int
cdevErrReqObject::sendNoBlock (cdevData& out, cdevData& result)
{
  return sendNoBlock (&out, &result);
}

int
cdevErrReqObject::sendNoBlock (cdevData& out, cdevData* result)
{
  return sendNoBlock (&out, result);
}

int
cdevErrReqObject::sendNoBlock (cdevData* out, cdevData& result)
{
  return sendNoBlock (out, &result);
}

int
cdevErrReqObject::sendNoBlock (cdevData* , cdevData* )
{
  system_.reportError (CDEV_SEVERITY_ERROR, system_.name(), 
		       this, "Attempt to send with an invalid request object.");
  return CDEV_INVALIDOBJ;
}

int cdevErrReqObject::sendCallback (cdevData& out, cdevCallback &callback)
{
  return sendCallback (&out, callback);
}  

int 
cdevErrReqObject::sendCallback (cdevData*      /* out      */, 
				cdevCallback & /* callback */)
{
  system_.reportError (CDEV_SEVERITY_ERROR, system_.name(), 
		       this, "Attempt to send with an invalid request object.");
  // send this request information to callback in the future
  return CDEV_INVALIDOBJ;
}  

int
cdevErrReqObject::getState (void)
{
  return CDEV_STATE_INVALID;
}

int
cdevErrReqObject::getAccess (void)
{
  return CDEV_ACCESS_NONE;
}

