# This is a Makefile for building channel access service for WIN32
.SUFFIXES : .exe .cpp .cxx .h .hh .cc .rc .asm .res
CC = cl
CFLAGS = /nologo /ZI /W3 /GX /I "$(CDEV)\include" /I "$(EPICS)\base\include" /D "WIN32" /D "_CDEV_BUILD_SVC" /D "_WINDOWS" /D "_MBCS" /c /Tp
LINK = link
LINK_FLAGS = kernel32.lib user32.lib advapi32.lib wsock32.lib $(CDEV)\lib\cdev.lib $(EPICS)\base\lib\ca.lib $(EPICS)\base\lib\com.lib /nologo /dll /incremental:yes /machine:I386 /out:"caService.dll"

WIN32_OBJS = caService.obj caRequestObject.obj caChannel.obj caNameSvc.obj caMonObj.obj caMisc.obj

all: caService.dll copydll

caService.dll: $(WIN32_OBJS)
        $(LINK) $(LINK_FLAGS) $(WIN32_OBJS)

copydll: caService.dll
        @if not exist $(CDEVSHOBJ) mkdir $(CDEVSHOBJ)
        @if exist $(CDEVSHOBJ) erase /Q $(CDEVSHOBJ)\caService.dll
        copy caService.dll $(CDEVSHOBJ)

clean:
        -@erase /Q caService.dll
        -@erase /Q caService.exp
        -@erase /Q caService.lib
        -@erase /Q *.obj

.cc.obj:
        -@erase /Q $@
        $(CC) $(CFLAGS)$<

