//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//       cdevSync class (abstract base class)
//
// Author:  Jie Chen & Chip Watson
//
// Revision History:
//   cdevSync.h,v
// Revision 1.3  1997/02/18  15:45:43  chen
// port to linux 2.0.x + addUserFdCallback
//
// Revision 1.2  1996/03/22  17:57:45  chen
// change attach/detach ReadFd to virtual
//
// Revision 1.1.1.1  1995/06/16  17:14:08  epics
// initial import of cdev
//
//
#ifndef _CDEV_SYNC_H
#define _CDEV_SYNC_H

#include <stdio.h>
#include <assert.h>
#include <cdevSpec.h>
#include <cdevFdSet.h>
#include <cdevTimeValue.h>

class CDEV_CLASS_SPEC cdevSync{
 public:
  // destructors
  virtual ~cdevSync (void);

  virtual int flush (void) = 0;
  // PURPOSE: pure virtual function to define intreface for net flush
  // REQUIRE: derived class provide implementation
  // PROMISE: return CDEV_SUCCESS

  virtual int poll  (void) = 0;
  // PURPOSE: pure virtual function to define intreface for polling method
  // REQUIRE: derived class provide implementation
  // PROMISE: return CDEV_SUCCESS: OK. return -1: network error

  virtual int pend  (int fd = -1) = 0;
  // PURPOSR: pure virtual function to define interface for pending method
  // REQUIRE: derived class provide implementation
  // PROMISE: return CDEV_SUCCESS, OK, return -1: network error

  virtual int pend  (double seconds, int fd = -1) = 0;
  // PURPOSR: pure virtual function to define interface for pending method
  // REQUIRE: derived class provide implementation
  // PROMISE: return CDEV_SUCCESS, OK, return CDEV_TIMEOUT: timeout.
  //          -1: network error

  virtual const char *className (void) const {return "cdevSync";}
  
 protected:
  // constructor
  cdevSync (void);

  virtual int attachReadFd (int fd);
  // PURPOSE: add a new file descriptor to mask
  // REQURIE: fd > 3. You know what I mean
  // PROMISE: return 0 success

  virtual int detachReadFd (int fd);
  // PURPOSE: remove a file descriptor from the mask
  // REQUIRE: fd > 3
  // PROMISE: return 0 success

  int handleEvents (void);
  // PURPOSE: wait until IO events arrive and dispatch IO events
  // REQUIRE: nothing
  // PROMISE: return 0: success, -1: error

  virtual int handleEvents (cdevTimeValue *tv);
  // PURPOSE: handle IO events for upto 'tv' long
  // REQUIRE: nothing
  // PROMISE: return 0: success at least one IO event occured, 1: timeout

  int waitFor (cdevFdSet &rmaskret,
	       cdevFdSet &wmaskret,
	       cdevFdSet &emaskret,
	       cdevTimeValue *how_long);
  // PURPOSE: Wait for IO events to occur upto time 'how_long'
  // REQUIRE: nothing
  // PROMISE: >0 IO event ready. 0 nothing, timeout

  void dispatch (int nfound, 
		 cdevFdSet &rmaskret,
		 cdevFdSet &wmaskret,
		 cdevFdSet &emaskret);
  // PURPOSE: dispath IO events to the appropriate service
  // REQUIRE: nothing
  // PROMISE: dispatched

  virtual void notifyService (int handle);
  // PURPOSE: notify low level service there are IO events
  // REQUIRE: derived class does real implementation
  // PROMISE: nothing

  int handleError (void);
  // PURPOSE: handle interrupt error while waiting for IO events
  // REQUIRE: nothing
  // PROMISE: return 1: interrupt or bad file descriptor, return -1: error

  int checkFds (void);
  // PURPOSE: check whether file descriptors are valid
  // REQUIRE: nothing
  // PROMISE: return 1 always

  int checkFd  (int fd);
  // PURPOSE: check whether file descriptor fd is valid
  // REQUIRE: nothing
  // PROMISE: return 0 success, -1, failure

  int maxHandle (int i, int j, int k);
  // PURPOSE: utility to calculate maximum of there integers
  // REQUIRE: nothing
  // PROMISE: maximum of there integers

  // File Descriptor Mask for IO Multiplexing
  cdevFdSet rdMask_;
  cdevFdSet wrMask_;
  cdevFdSet exMask_;
};
#endif





