//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdevSvcFinder class (Bind a service from a service name)
//
// Author:  Jie Chen
//
// Revision History:
//   cdevSvcFinder.h,v
// Revision 1.5  1997/08/18  14:16:31  akers
// Ongoing development of CDEV accounting
//
// Revision 1.4  1997/08/15  18:08:33  akers
// Addition of CDEV Accounting
//
// Revision 1.3  1995/09/20  16:22:21  chen
// Change findService to virtual
//
// Revision 1.2  1995/06/30  16:01:35  chen
// use generic list
//
// Revision 1.1.1.1  1995/06/16  17:14:07  epics
// initial import of cdev
//
//
#ifndef _CDEV_SVC_FINDER_H
#define _CDEV_SVC_FINDER_H

#include <cdevSystem.h>
#include <shObjLoader.h>
#include <cdevSlist.h>

class CDEV_CLASS_SPEC cdevSvcFinder
{
 public:
  //constructor and destrcutor
  cdevSvcFinder(cdevSystem & system = cdevSystem::defaultSystem());
  ~cdevSvcFinder (void);

  int getService(char *serviceName, cdevService* &service);
  // PURPOSE: get or load a service into system
  // REQUIRE: serviceName != 0 and callers provide pointer service
  // PROMISE: return 0: service loaded. return -1: failure

 private:
  // deny assignment and copy
  cdevSvcFinder (const cdevSvcFinder& src);
  cdevSvcFinder& operator = (const cdevSvcFinder& src);
  // internal functions

#ifdef SHOBJ
  cdevService *loadService (char *serviceName);
#else
  virtual cdevService *findService (char *serviceName);
#endif
  // data area
  cdevSlist   ldList_;
  cdevSystem& system_;
};
#endif
