.SUFFIXES: .cc .obj

APPNAME        = Client/Server Monitor Test
ARCH           = WINNT-4.0
SHOBJ          = YES

BINARIES = $(BASEBIN)\MonitorTestServer.exe \
           $(CDEVLIB)\MonitorTestService.dll \
           $(CDEVLIB)\MonitorTestService.lib \
		   $(BASEBIN)\MonitorTest.exe \
		   $(BASEBIN)\MonitorReader.exe \
		   $(BASEBIN)\MonitorOffTest.exe \
		   $(BASEBIN)\MonitorWriter.exe \
		   $(BASEBIN)\DefaultServerTest.exe

include ..\..\include\makeinclude\Makefile.WINNT-4.0

CXXINCLUDES    = /I .\\ 
CXXEXTRA_DLL   = /D "MONITOR_TEST_SERVICE_API=__declspec(dllexport)"
CXXEXTRA_LIB   = /D "MONITOR_TEST_SERVICE_API="

!IF "$(SHOBJ)" == "YES"
TARGETS  = $(BASEBIN)\MonitorTestServer.exe \
           $(CDEVLIB)\MonitorTestService.dll \
		   $(BASEBIN)\MonitorTest.exe \
		   $(BASEBIN)\MonitorReader.exe \
		   $(BASEBIN)\MonitorOffTest.exe \
		   $(BASEBIN)\MonitorWriter.exe \
		   $(BASEBIN)\DefaultServerTest.exe
!ELSE
TARGETS  = $(BASEBIN)\MonitorTestServer.exe \
           $(CDEVLIB)\MonitorTestService.lib \
		   $(BASEBIN)\MonitorTest.exe \
		   $(BASEBIN)\MonitorReader.exe \
		   $(BASEBIN)\MonitorOffTest.exe \
		   $(BASEBIN)\MonitorWriter.exe \
		   $(BASEBIN)\DefaultServerTest.exe
!ENDIF

targets : $(TARGETS)
		
$(CDEVLIB)\MonitorTestService.dll : $(OBJDIR)\MonitorTestService.obj
	@echo ^ ^ ^ =^> Linking $(@F) 
	-@if exist $@ erase $@
	-@if not exist $(@D) mkdir $(@D)
	@$(LIB32) $(CDEVLIB)\cdev.lib $(CDEVLIB)\cdevGenericServer.lib\
	$(LINK_DLL_FLAGS) /out:$@ /implib:$(@D)\$(@B).lib $?
	-@copy $@ $(CDEVSHOBJ)\$(CDEVVERSION)\$(@F) > nul
	@echo ^ ^ ^ ^ ^ ^ Done...
	
$(CDEVLIB)\MonitorTestService.lib : $(OBJDIR)\MonitorTestService.obj
	@echo ^ ^ ^ =^> Linking $(@F) 
	-@if exist $@ erase $@
	-@if not exist $(@D) mkdir $(@D)
	@$(LIB32) $(CDEVLIB)\cdev.lib $(CDEVLIB)\cdevGenericServer.lib\
	$(LINK_LIB_FLAGS) /out:$@ $?
	@echo ^ ^ ^ ^ ^ ^ Done...

$(BASEBIN)\MonitorTestServer.exe : .exec\$(TARGETDIR)\MonitorTestServer.obj $(OBJDIR)\MonitorTestAttrib.obj
	-@if exist $@ erase $@
	@echo ^ ^ ^ ^ ^ ^ =^> Linking $(@F)
	$(LINK) $(CDEVLIB)\cdev.lib $(CDEVLIB)\cdevGenericServer.lib \
	$(LINK_EXE_FLAGS) /out:$@ $?
	@echo ^ ^ ^ ^ ^ ^ ^ ^ ^ Done...

$(BASEBIN)\MonitorTest.exe : .exec\$(TARGETDIR)\MonitorTest.obj
	-@if exist $@ erase $@
	@echo ^ ^ ^ ^ ^ ^ =^> Linking $(@F)
	$(LINK) $(CDEVLIB)\cdev.lib $(CDEVLIB)\cdevGenericServer.lib \
	$(LINK_EXE_FLAGS) /out:$@ $? 
	@echo ^ ^ ^ ^ ^ ^ ^ ^ ^ Done...

$(BASEBIN)\MonitorReader.exe : .exec\$(TARGETDIR)\MonitorReader.obj
	-@if exist $@ erase $@
	@echo ^ ^ ^ ^ ^ ^ =^> Linking $(@F)
	$(LINK) $(CDEVLIB)\cdev.lib $(CDEVLIB)\cdevGenericServer.lib \
	$(LINK_EXE_FLAGS) /out:$@ $? 
	@echo ^ ^ ^ ^ ^ ^ ^ ^ ^ Done...

$(BASEBIN)\MonitorOffTest.exe : .exec\$(TARGETDIR)\MonitorOffTest.obj
	-@if exist $@ erase $@
	@echo ^ ^ ^ ^ ^ ^ =^> Linking $(@F)
	$(LINK) $(CDEVLIB)\cdev.lib $(CDEVLIB)\cdevGenericServer.lib \
	$(LINK_EXE_FLAGS) /out:$@ $? 
	@echo ^ ^ ^ ^ ^ ^ ^ ^ ^ Done...

$(BASEBIN)\MonitorWriter.exe : .exec\$(TARGETDIR)\MonitorWriter.obj
	-@if exist $@ erase $@
	@echo ^ ^ ^ ^ ^ ^ =^> Linking $(@F)
	$(LINK) $(CDEVLIB)\cdev.lib $(CDEVLIB)\cdevGenericServer.lib \
	$(LINK_EXE_FLAGS) /out:$@ $? 
	@echo ^ ^ ^ ^ ^ ^ ^ ^ ^ Done...

$(BASEBIN)\DefaultServerTest.exe : .exec\$(TARGETDIR)\DefaultServerTest.obj
	-@if exist $@ erase $@
	@echo ^ ^ ^ ^ ^ ^ =^> Linking $(@F)
	$(LINK) $(CDEVLIB)\cdev.lib $(CDEVLIB)\cdevGenericServer.lib \
	$(LINK_EXE_FLAGS) /out:$@ $? 
	@echo ^ ^ ^ ^ ^ ^ ^ ^ ^ Done...

