#ifndef _VIRTUAL_ATTRIB_H_
#define _VIRTUAL_ATTRIB_H_ 1

#include <cdevData.h>
#include <MonitorTestServer.h>	

	
// *****************************************************************************
// * class MonitorTestAttrib:
// *	This class maintains a list of items that make-up a MonitorTest Attrib.  And
// *	access mechanisms.
// *****************************************************************************
class MonitorTestAttrib
{
private:
	char            * device;
	char            * attrib;
	cdevMonitorNode * monitors;
		
	double value;
	char   status  [255];
 	char   severity[255];
	char   units   [255];
	double alarmHigh;
	double alarmLow;
	double warningHigh;
	double warningLow;
	double controlHigh;
	double controlLow;
	
	int    resultCode;
public:
	 MonitorTestAttrib (char * Device, char * Attrib);
	~MonitorTestAttrib ( void );
	
	int    setFromData    ( cdevData * data );
	void   getToData      ( cdevData * data, cdevData * context = NULL );
	void   getAllToData   ( cdevData * data );
	
	int    setValue       ( double Value );
	int    setStatus      ( char * Status );
	int    setSeverity    ( char * Severity );
	int    setUnits       ( char * Units );
	int    setAlarmHigh   ( double AlarmHigh );
	int    setAlarmLow    ( double AlarmLow );  
	int    setWarningHigh ( double WarningHigh );
	int    setWarningLow  ( double WarningLow );
	int    setControlHigh ( double ControlHigh );
	int    setControlLow  ( double ControlLow );
	void   checkAlarms    ( void );
	
	double getValue       ( void ) { return value; }
	char * getStatus      ( void ) { return status; }
	char * getSeverity    ( void ) { return severity; }
	char * getUnits       ( void ) { return units; }
	double getAlarmHigh   ( void ) { return alarmHigh; }
	double getAlarmLow    ( void ) { return alarmLow; }
	double getWarningHigh ( void ) { return warningHigh; }
	double getWarningLow  ( void ) { return warningLow; }
	double getControlHigh ( void ) { return controlHigh; }
	double getControlLow  ( void ) { return controlLow; }
	int    getResultCode  ( void ) { return resultCode; }
	
	void   insertMonitor  ( cdevMonitorTable * table, cdevMessage * message );
	void   removeMonitor  ( cdevMonitorTable * table, cdevMessage * message );
};

#endif
