/*
//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      Header File for rsvcServer Query
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
//
//
*/
#ifndef _RSVC_LOGIC_H
#define _RSVC_LOGIC_H

#define RSVC_LOGIC_UNK 200
#define RSVC_LOGIC_INT 201
#define RSVC_LOGIC_DBL 202
#define RSVC_LOGIC_STR 203

/* data structure to hold all values on the stack */
typedef struct _rsvc_logic_data
{
  short type;
  union {
    int      ival;
    double   dval;
    char*    string;
  }u;
}rsvc_logic_data;

/* global input test string for parser */
extern char* _logic_input_text;

/* global parsing engine               */
extern void* _logic_q_eng;

/* instruction set */
typedef int (*rsvcLogicInst)(void* data);

#define RSVC_LOGIC_STOP (rsvcLogicInst) 0

/* function decleration of supporting functions */
#ifdef __cplusplus
extern "C" {
#endif

#if defined (__STDC__) || defined (__cplusplus)
extern rsvc_logic_data* new_logic_data      (void);
extern rsvc_logic_data* logic_data_dup      (rsvc_logic_data* data);
extern void logic_data_assign_int           (rsvc_logic_data* data, int val);
extern void logic_data_assign_dbl           (rsvc_logic_data* data, double val);
extern void logic_data_assign_str           (rsvc_logic_data* data, char* str);
extern void free_logic_data                 (rsvc_logic_data* data);

extern void set_input_text                  (char* text);
extern void set_query_engine                (void* eng);

extern rsvcLogicInst* logic_code            (rsvcLogicInst f);
extern int  logic_val_push                  (void* data);
extern int  rsvc_data_equal_int             (void* data);
extern int  rsvc_data_equal_dbl             (void* data);
extern int  rsvc_data_equal_str             (void* data);
extern int  rsvc_data_has_str               (void* data);
extern int  rsvc_data_less_int              (void* data);
extern int  rsvc_data_less_dbl              (void* data);
extern int  rsvc_data_greater_int           (void* data);
extern int  rsvc_data_greater_dbl           (void* data);
extern int  rsvc_data_lesseq_int            (void* data);
extern int  rsvc_data_lesseq_dbl            (void* data);
extern int  rsvc_data_greatereq_int         (void* data);
extern int  rsvc_data_greatereq_dbl         (void* data);
extern int  rsvc_data_noequal_int           (void* data);
extern int  rsvc_data_noequal_dbl           (void* data);
extern int  rsvc_data_noequal_str           (void* data);
extern int  rsvc_logic_and                  (void* data);
extern int  rsvc_logic_or                   (void* data);
extern int  rsvc_logic_neg                  (void* data);
extern int  rsvc_logic_end                  (void* data);

#else
extern rsvc_logic_data* new_logic_data      ();
extern rsvc_logic_data* logic_data_dup      ();
extern void logic_data_assign_int           ();
extern void logic_data_assign_dbl           ();
extern void logic_data_assign_str           ();
extern void free_logic_data                 ();
extern void set_input_text                  ();
extern void set_query_engine                ();
extern rsvcLogicInst* logic_code            ();
extern int  logic_val_push                  ();
extern int  rsvc_data_equal_int             ();
extern int  rsvc_data_equal_dbl             ();
extern int  rsvc_data_equal_str             ();
extern int  rsvc_data_has_str               ();
extern int  rsvc_data_less_int              ();
extern int  rsvc_data_less_dbl              ();
extern int  rsvc_data_greater_int           ();
extern int  rsvc_data_greater_dbl           ();
extern int  rsvc_data_lesseq_int            ();
extern int  rsvc_data_lesseq_dbl            ();
extern int  rsvc_data_greatereq_int         ();
extern int  rsvc_data_greatereq_dbl         ();
extern int  rsvc_data_noequal_int           ();
extern int  rsvc_data_noequal_dbl           ();
extern int  rsvc_data_noequal_str           ();
extern int  rsvc_logic_and                  ();
extern int  rsvc_logic_or                   ();
extern int  rsvc_logic_neg                  ();
extern int  rsvc_logic_end                  ();
#endif

#ifdef __cplusplus
};
#endif


#endif
