//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Server Cache Data Attributes
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_CACHE_DATA_ATTR_H
#define _RSVC_CACHE_DATA_ATTR_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <rsvcNetData.h>
#include <rsvcHashable.h>
#include <rsvcHash.h>
#include <rsvcCacheData.h>

class rsvcCbk;

class rsvcCacheDataAttr : public rsvcHashable
{
public:
  // constructor and destructor
  rsvcCacheDataAttr            (char* attr, rsvcCacheData& cache);
  virtual ~rsvcCacheDataAttr   (void);

  // return hash code
  unsigned int hash (void);

  // monitor on/off
  // outdata's  are newly allocated data. 
  // remember to free those
  virtual int monitorOn        (rsvcCbk& cbk);
  virtual int monitorOff       (rsvcCbk& cbk);
  // monitor off all with same ioptr
  virtual int monitorOff       (void* ioptr);
  virtual int getValue         (rsvcCbk& cbk);

  // return attribute name
  char*       attrName         (void) const;

  // notify channels
  void        notifyChannels   (void);

protected:

  // remove all callbacks from the lists
  void          removeAllCbks   (void);
  
  // attribute name
  char*         name_;

  // all callback list : (with all cbk pointers)
  rsvcHash monitorList_;

  // whole cached data storage
  rsvcCacheData& cache_;

  // deny access to copy and assignment operations
  rsvcCacheDataAttr (const rsvcCacheDataAttr& attr);
  rsvcCacheDataAttr& operator = (const rsvcCacheDataAttr& attr);
};
#endif
