#include <cdevMessageBinary.h>
#include <cdevMessage.h>

char * myDevices[10] =
	{
	"Device 0",
	"Device 1",
	"Device 2",
	"Device 3",
	"Device 4",
	"Device 5",
	"Device 6",
	"Device 7",
	"Device 8",
	"Device 9"
	};

int myTags[] = 
	{
	1,2,3,4,5,6,7,8,9
	};

char * myTagNames[] =
	{
	"My Tag 1",
	"My Tag 2",
	"My Tag 3",
	"My Tag 4",
	"My tag 5",
	"My Tag 6",
	"My Tag 7",
	"My Tag 8",
	"My Tag 9"
	};
	
int main()
	{
	short    clientID;
	unsigned transIndex, cancelTransIndex;
	unsigned localDataIndex;
	unsigned foreignDataIndex;
	unsigned operationCode;
	int      completionCode;
	unsigned deviceCount;
	char **  deviceList;
	char *   message;
	cdevData data, context, tagMap;

	data.insert("value", "This is a test value");
	data.insert("status", "This is a test status");
	data.insert("displayLow", 1);
	data.insert("displayHigh", 2);
	data.insert("controlLow", 3);
	data.insert("controlHigh", 4);
	
	context.insert("value", "This is a context test value");
	context.insert("status", "This is a context test status");
	context.insert("displayLow", 5);
	context.insert("displayHigh", 6);
	context.insert("controlLow", 7);
	context.insert("controlHigh", 8);	

	tagMap.insert (1, myTags, 9);
	tagMap.insert (2, myTagNames, 9);
	
	cdevMessageBinary packet1;
	cdevMessageBinary packet2 (1);
	cdevMessageBinary packet3 (1,  2);
	cdevMessageBinary packet3a(1,  2, 500);
	cdevMessageBinary packet4 (1,  2, 500, 3);
	cdevMessageBinary packet5 (1,  2, 500, 3, 4);
	cdevMessageBinary packet5a(1,  2, 500, 3, 4, 5);
	cdevMessageBinary packet6 (1,  2, 500, 3, 4, 5, 6, 10);
	cdevMessageBinary packet7 (1,  2, 500, 3, 4, 5, 6, 10, myDevices);
	cdevMessageBinary packet8 (1,  2, 500, 3, 4, 5, 6, 10, myDevices, "set VAL");
	cdevMessageBinary packet9 (1,  2, 500, 3, 4, 5, 6, 10, myDevices, "set VAL", &data);
	cdevMessageBinary packet10(1,  2, 500, 3, 4, 5, 6, 10, myDevices, "set VAL", &data, &context);
	cdevMessageBinary packet11(1,  2, 500, 3, 4, 5, 6, 10, myDevices, "set VAL", &data, &context, &tagMap);
	cdevMessageBinary packet12(-1, 2, 500, 3, 4, 5, 6, 10, myDevices, "set VAL", &data, &context, &tagMap);
	cdevMessageBinary packet13(-1, 0, 500, 3, 4, 5, 6, 10, myDevices, "set VAL", &data, &context, &tagMap);
	cdevMessageBinary packet14(-1, 0,   0, 3, 4, 5, 6, 10, myDevices, "set VAL", &data, &context, &tagMap);
	cdevMessageBinary packet14a(-1, 0,  0, 0, 4, 5, 6, 10, myDevices, "set VAL", &data, &context, &tagMap);
	cdevMessageBinary packet15(-1, 0,   0, 0, 0, 5, 6, 10, myDevices, "set VAL", &data, &context, &tagMap);
	cdevMessageBinary packet16(-1, 0,   0, 0, 0, 0, 0, 10, myDevices, "set VAL", &data, &context, &tagMap);
	cdevMessageBinary packet16a(-1, 0,  0, 0, 0, 0, 0, 0, myDevices, "set VAL", &data, &context, &tagMap);
	cdevMessageBinary packet17(-1, 0,   0, 0, 0, 0, 0, 0, NULL, "set VAL", &data, &context, &tagMap);
	cdevMessageBinary packet18(-1, 0,   0, 0, 0, 0, 0, 0, NULL, NULL, &data, &context, &tagMap);
	cdevMessageBinary packet19(-1, 0,   0, 0, 0, 0, 0, 0, NULL, NULL, NULL, &context, &tagMap);
	cdevMessageBinary packet20(-1, 0,   0, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, &tagMap);
	cdevMessageBinary packet21(-1, 0,   0, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL);
	
	packet1.asciiDump();
	packet2.asciiDump();
	packet3.asciiDump();
	packet3a.asciiDump();
	packet4.asciiDump();
	packet5.asciiDump();
	packet5a.asciiDump();
	packet6.asciiDump();
	packet7.asciiDump();
	packet8.asciiDump();
	packet9.asciiDump();
	packet10.asciiDump();
	packet11.asciiDump();
	packet12.asciiDump();
	packet13.asciiDump();
	packet14.asciiDump();
	packet14a.asciiDump();
	packet15.asciiDump();
	packet16.asciiDump();
	packet16a.asciiDump();
	packet17.asciiDump();
	packet18.asciiDump();
	packet19.asciiDump();
	packet20.asciiDump();
	packet21.asciiDump();

	cdevMessageBinary packet22;
	packet11.get(clientID, transIndex, cancelTransIndex, localDataIndex, foreignDataIndex, operationCode, completionCode, deviceCount, deviceList, message, data, context, tagMap);
	packet22.set(clientID, transIndex, cancelTransIndex, localDataIndex, foreignDataIndex, operationCode, completionCode, deviceCount, deviceList, message, &data, &context, &tagMap);
	packet22.asciiDump();

	for(int i=0; i<deviceCount; i++) delete deviceList[i];
	delete deviceList;
	delete message;
		
	char * binary; 
	size_t binaryLen;
	
	packet22.streamOut(&binary, &binaryLen);
	cdevMessage message1(binary, binaryLen);
	message1.asciiDump();

	binary = NULL;
	binaryLen = 0;
	
	message1.streamOut(&binary, &binaryLen);
	cdevMessageBinary packet23;
	packet23.attachData(binary, binaryLen);
	packet23.asciiDump();

	fprintf(stdout, "#####################################################\n");
	fprintf(stdout, "###    TESTING THE REGISTER AND IMPORT METHODS    ###\n");
	fprintf(stdout, "#####################################################\n");
	cdevPacket::registerImportMethod(cdevMessageBinary::CDEV_PACKET_VERSION, 
	                                 cdevMessage::import);
	
	cdevPacket * message2 = cdevPacket::import(packet23);
	message2->asciiDump();
	delete message2;

	return 0;
	}
	
