#include <cdevMessageBinary.h>
#include <cdevMessage.h>

char * myDevices[10] =
	{
	"Device 0",
	"Device 1",
	"Device 2",
	"Device 3",
	"Device 4",
	"Device 5",
	"Device 6",
	"Device 7",
	"Device 8",
	"Device 9"
	};

int myTags[] = 
	{
	1,2,3,4,5,6,7,8,9
	};

char * myTagNames[] =
	{
	"My Tag 1",
	"My Tag 2",
	"My Tag 3",
	"My Tag 4",
	"My tag 5",
	"My Tag 6",
	"My Tag 7",
	"My Tag 8",
	"My Tag 9"
	};
	
char * valueTag[2] = {"This is a test1", "This is a test2"};
int    statusTag[2] = {1, 2};
double severityTag[2] = {2.0, 3.0};

int main()
	{
	short    clientID;
	unsigned transIndex, cancelTransIndex;
	unsigned localDataIndex;
	unsigned foreignDataIndex;
	unsigned operationCode;
	int      completionCode;
	unsigned deviceCount;
	char **  deviceList;
	char *   message;
	cdevData data, context, tagMap;

	data.insert("value", valueTag, 2, 1);
	data.insert("status", statusTag, 2, 1);
	data.insert("severity", severityTag, 2, 1);
	
	context.insert("value", valueTag, 1, 1);
	context.insert("status", statusTag, 1, 1);
	context.insert("severity", severityTag, 1, 1);

	tagMap.insert (1, myTags, 9);
	tagMap.insert (2, myTagNames, 9);
	
	cdevMessageBinary packet11(1,  2, 500, 3, 4, 5, 6, 10, myDevices, "set VAL", &data, &context, &tagMap);
	packet11.asciiDump();

	cdevMessageBinary packet22;
	packet11.get(clientID, transIndex, cancelTransIndex, localDataIndex, foreignDataIndex, operationCode, completionCode, deviceCount, deviceList, message, data, context, tagMap);
	packet22.set(clientID, transIndex, cancelTransIndex, localDataIndex, foreignDataIndex, operationCode, completionCode, deviceCount, deviceList, message, &data, &context, &tagMap);
	packet22.asciiDump();

	for(int i=0; i<deviceCount; i++) delete deviceList[i];
	delete deviceList;
	delete message;
		
	char * binary; 
	size_t binaryLen;
	
	packet22.streamOut(&binary, &binaryLen);
	cdevMessage message1(binary, binaryLen);
	message1.asciiDump();

	binary = NULL;
	binaryLen = 0;
	
	message1.streamOut(&binary, &binaryLen);
	cdevMessageBinary packet23;
	packet23.attachData(binary, binaryLen);
	packet23.asciiDump();

	fprintf(stdout, "#####################################################\n");
	fprintf(stdout, "###    TESTING THE REGISTER AND IMPORT METHODS    ###\n");
	fprintf(stdout, "#####################################################\n");
	cdevPacket::registerImportMethod(cdevMessageBinary::CDEV_PACKET_VERSION, 
	                                 cdevMessage::import);
	
	cdevPacket * message2 = cdevPacket::import(packet23);
	message2->asciiDump();
	delete message2;
	
	return 0;
	}
	
