//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Server Query Message Logic Expression Parser Supporting Routines
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   rsvcLogicSup.cc,v
// Revision 1.1  1998/01/22  17:08:17  akers
// Addition of new NameServer
//
//
//
#include <stdio.h>
#include <string.h>
#include <rsvcData.h>
#include <rsvcLogic.h>

/* global parsing engine */
void* _logic_q_eng = 0;

rsvc_logic_data*
new_logic_data (void)
{
  rsvc_logic_data* data = 
    (rsvc_logic_data *)malloc (sizeof (rsvc_logic_data));
  data->type = RSVC_LOGIC_UNK;
  return data;
}

rsvc_logic_data*
logic_data_dup (rsvc_logic_data* data)
{
  rsvc_logic_data* ndata = new_logic_data ();
  ndata->type = data->type;
  if (data->type == RSVC_LOGIC_INT) 
    ndata->u.ival = data->u.ival;
  else if (data->type == RSVC_LOGIC_DBL)
    ndata->u.dval = data->u.dval;
  else if (data->type == RSVC_LOGIC_STR) {
    ndata->u.string = (char *)malloc ((strlen (data->u.string) + 1)*
				      sizeof (char));
    strcpy (ndata->u.string, data->u.string);
  }
  return ndata;
}

void
logic_data_assign_int (rsvc_logic_data* data, int val)
{
  data->type = RSVC_LOGIC_INT;
  data->u.ival = val;
}

void
logic_data_assign_dbl (rsvc_logic_data* data, double val)
{
  data->type = RSVC_LOGIC_DBL;
  data->u.dval = val;
}

void
logic_data_assign_str (rsvc_logic_data* data, char* val)
{
  data->type = RSVC_LOGIC_STR;
  data->u.string = (char *)malloc ((strlen (val) + 1)*sizeof (char));
  strcpy (data->u.string, val);
}

void
free_logic_data (rsvc_logic_data* data)
{
  if (data->type == RSVC_LOGIC_STR) 
    free (data->u.string);
  data->type = RSVC_LOGIC_UNK;
  free (data);
}

void
set_query_engine (void* eng)
{
  _logic_q_eng = eng;
}

#ifdef _RSVC_PARSE_DEBUG
#include <rsvcLogicQEng.h>

//char* log_exp = "(value > 50 && severity > 8) && !class like 'epics'";
char* log_exp = "(value > 50 && severity > 8) && ! class like 'epics'";

main (int argc, char** argv)
{
  char expression[256];
  rsvcData data[100];
  int      i = 0;
  rsvcLogicQEng qeng (log_exp);

  
  for (i = 0; i < 100; i++) {
    data[i].insert ("value", i);
    data[i].insert ("severity", i/10);
    if (i < 50) {
      data[i].insert ("status", 0);
      data[i].insert ("class", "epics");
    }
    else {
      data[i].insert ("status", 1);
      data[i].insert ("class", "coda");
    }
  }


  if (qeng.parse () != -1) {
    for (i = 0; i < 100; i++) {
      if (qeng.execute (data[i])) 
	printf ("data %d is ok\n", i);
    }
  }

  qeng.clean ();
}
#endif

  
