//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of rsvcDataStoreTable Class
//
// Author:  Jie Chen
//
// Revision History:
//   rsvcDataStoreTable.cc,v
// Revision 1.2  1998/01/22  20:04:07  chen
// to make it work with cdevReactor
//
// Revision 1.1  1998/01/22  17:08:08  akers
// Addition of new NameServer
//
//
//
#include "rsvcDataStoreTable.h"

static unsigned int 
store_table_hash (char* str)
{
  unsigned int h = 0, g;

  for (int i = 0; str[i] != '\0'; i++){
    h = (h << 4) + str[i];
    // assume 32 bit integer
    if (g = h & 0xf0000000){
      h ^= g >> 24;
      h ^= g;
    }
  }
  return h;
}

rsvcDataStoreTable::rsvcDataStoreTable (unsigned int max, unsigned int lf)
:table_ (max, lf)
{
#ifdef _TRACE_OBJECTS
  printf ("Create rsvcDataStoreTable Class Object\n");
#endif
}

rsvcDataStoreTable::~rsvcDataStoreTable (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Create rsvcDataStoreTable Class Object\n");
#endif

  rsvcHashIterator ite (table_);
  rsvcDataStore* store = 0;

  for (ite.init (); !ite; ++ite) {
    store = (rsvcDataStore *) ite ();
    delete store;
  }
}

rsvcDataStore *
rsvcDataStoreTable::find (char* name)
{
  // calculate hash code for this name
  unsigned int hashcode = store_table_hash (name);

  // access a particular bucket
  rsvcHSlist& list = table_.bucketRef (hashcode);
  rsvcHSlistIterator ite (list);
  rsvcDataStore* store = 0;

  for (ite.init (); !ite; ++ite) {
    store = (rsvcDataStore *) ite ();
    if (strcmp (store->name (), name) == 0)
      return store;
  }
  return 0;
}


int
rsvcDataStoreTable::add (rsvcDataStore* store)
{
  rsvcHSlist& list = table_.bucketRef (store);

  rsvcHSlistIterator ite (list);
  rsvcDataStore* tstore = 0;

  for (ite.init (); !ite; ++ite) {
    tstore = (rsvcDataStore *) ite ();
    if (strcmp (store->name (), tstore->name ()) == 0)
      return RSVC_ERROR;
  }
  list.add (store);
  return RSVC_SUCCESS;
}


void
rsvcDataStoreTable::monitorOff (void* io)
{
  rsvcHashIterator ite (table_);
  rsvcDataStore *store = 0;

  for (ite.init (); !ite; ++ite) {
    store = (rsvcDataStore *) ite ();
    store->monitorOff (io);
  }
}

void
rsvcDataStoreTable::handleClose (void* io)
{
  rsvcHashIterator ite (table_);
  rsvcDataStore *store = 0;

  for (ite.init (); !ite; ++ite) {
    store = (rsvcDataStore *) ite ();
    store->handleClose (io);
  }
}

int
rsvcDataStoreTable::openDatabase (char* name)
{
  rsvcDataStore* datastore = rsvcDataStore::createDataStore (name);

  if (datastore && add (datastore) == RSVC_SUCCESS)
    return datastore->openDatabase ();
  return RSVC_ERROR;
}



  
  
