#include <cdevSystem.h>
#include <cdevRequestObject.h>
#include <cdevDevice.h>
#include <cdevGroup.h>
#include <cdevCommon.h>
#include <cdevClock.h>

int callbackCount   = 0;

void monitorCallback (int status, void *, cdevRequestObject &, cdevData &)
	{
	if (status==CDEV_SUCCESS) callbackCount++;
	}

#define POSTCOUNT 1
#define REPEATCOUNT 2

int main(int argc, char ** argv)
{
if(argc<4)
	{
	printf("Format is: %s [device] [attrib] [time in seconds]\n", argv[0]);
	return 0;
	}
int seconds = atoi(argv[3]);
if(seconds==0)
	{
	printf("Format is: %s [device] [attrib] [time in seconds]\n", argv[0]);
	printf("Time period of 0 specified...\n");
	return 0;
	}
	
cdevCallback cb(monitorCallback, NULL);
char command[255];

sprintf(command, "monitorOn %s", argv[2]);
cdevRequestObject & mOnReq = cdevRequestObject::attachRef(argv[1], command);

sprintf(command, "monitorOff %s", argv[2]);
cdevRequestObject & mOffReq = cdevRequestObject::attachRef(argv[1], command);

printf("Receiving monitors on device: %s, attribute: %s for %i seconds...\n", argv[1], argv[2], seconds);
cdevClock timer;
timer.schedule(NULL, (double)seconds);
mOnReq.sendCallback(NULL, cb);
while(!timer.expired()) cdevSystem::defaultSystem().poll();
mOffReq.sendCallback(NULL, cb);

printf("Received %i callbacks in %i seconds - %f callbacks/second\n", callbackCount, seconds, (double)callbackCount/seconds);
return 0;
}
