#if !defined (_CDEV_GATEWAY_H)
#define _CDEV_GATEWAY_H

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <cdevSystem.h>
#include <cdevServer.h>

class GatewayServer : public cdevServer
{
private:
	int nextCollectionInt;
	
public:
	GatewayServer ( char * domain, char * server, unsigned short port, double pulse );
	virtual ~GatewayServer         ( void );
	virtual int  handleTimeout     ( void );
	virtual void processMessages   ( void );

	static  void gatewayCallback   ( int, void *, cdevRequestObject &, cdevData &);
	static  void fdChangedCallback ( int fd, int opened, void * arg );
};



class GatewayHandler : public cdevEventHandler
{
friend class GatewayServer;

public:
	GatewayHandler (cdevSystem & Sys, int Fd) : sys(Sys), fd(Fd) {}
	virtual ~GatewayHandler (void)       {};
	virtual int getHandle      (void) const { return fd; }
 	virtual int handleInput    (void)       { sys.pend(1.0); return 0; }
	virtual int handleOutput   (void)       { sys.pend(1.0); return 0; }
	virtual int handleClose    (void)       { return 0; }

protected:
	int          fd;
	cdevSystem & sys;
};

#endif /* _CDEV_GATEWAY_H */
