#define _POSIX_SOURCE_ 1
#ifndef __EXTENSIONS__
# define __EXTENSIONS__
#endif

#include <tcl.h>
#include <tk.h>
#define Widget int
#include <codaRegistry.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <string.h>

#define DEF_DD_NAME "default"
#include <dd_sys.h>
#include <dd_user.h>
#include <dd_config.h>
#include <dd_dcom.h>
#include <fifo.h>

#ifdef LINUX
#include <stdarg.h>
#endif

struct dd_dcom_str *dd_dcom;

#ifndef NO_X11
static Tk_Window mainWindow;	/* The main window for the application.  If
				 * NULL then the application no longer
				 * exists. */
#endif
static Tcl_Interp *interp;	/* Interpreter for this application. */
static char *tcl_RcFileName = NULL;	/* Name of a user-specific startup script
					 * to source if the application is being run
					 * interactively (e.g. "~/.wishrc").  Set
					 * by Tcl_AppInit.  NULL means don't source
					 * anything ever. */
static Tcl_DString command;	/* Used to assemble lines of terminal input
				 * into Tcl commands. */
static int tty;			/* Non-zero means standard input is a
				 * terminal-like device.  Zero means it's
				 * a file. */
static char updateCmd[] = "dp_update";
static char exitCmd[] = "exit";
static char errorExitCmd[] = "exit 1";

long Tk_doneFlag__= 0;

int master             = 0;
int print              = 0;
int broadcast          = 0;
int warning            = 0;
char *application      = "clastest";
char *uniq_name        = "ddmon";
char *init_tcl_script  = NULL;
int done               = 0;
int check_time         = 4;
static time_t last_time = (time_t) 0;
char temp[128];
char *host             ;
int pid                ;

char *dd_name;
int tape_fifo          = 0;
int scaler_fifo        = 1;
char *scaler_fifo_name = "SCALER";
int scaler_fifo_num    = 2;

static int synchronize = 0;
static char *display = NULL;
static char *geometry = NULL;
static char *windowid = NULL;
static Tk_ArgvInfo argTable[] = {
  {"-tape", TK_ARGV_CONSTANT, (char *) 0, (char *) &tape_fifo,
   "fifo index for tape fifo"},
  {"-scaler", TK_ARGV_INT, (char *) 1, (char *) &scaler_fifo,
   "fifo index for scaler fifo"},
  {"-sname", TK_ARGV_STRING, (char *) "SCALER", (char *) &scaler_fifo_name,
   "Name to use for scaler fifo"},
  {"-snum", TK_ARGV_INT, (char *) 1, (char *) &scaler_fifo_num,
   "fifo number for scaler fifor"},
  {"-m", TK_ARGV_CONSTANT, (char *) 1, (char *) &master,
   "dd_monitor is a DD master"},
  {"-b", TK_ARGV_CONSTANT, (char *) 1, (char *) &broadcast,
   "allow broadcast"},
  {"-p", TK_ARGV_CONSTANT, (char *) 1, (char *) &print,
   "display statistics"},
  {"-c", TK_ARGV_INT, (char *) 1, (char *) &check_time,
   "update interval (seconds)."},
  {"-use", TK_ARGV_STRING, (char *) 0, (char *) &windowid,
   "windowid to embed in"},
  {(char *) NULL, TK_ARGV_END, (char *) NULL, (char *) NULL,
   (char *) NULL}
};

static void		Prompt _ANSI_ARGS_((Tcl_Interp *interp, int partial));
static void		StdinProc _ANSI_ARGS_((ClientData clientData,
					       int mask));

void quit_callback(int sig);
void init_dd(void);
void init_dd_tcl(void);
void print_dd_stats(void);
void broadcast_dd_stats(void);
void dd_done(void);


/*
 * ----------------------------------------------------------------------
 * 
 * Prompt --
 * 
 * Issue a prompt on standard output, or invoke a script to issue the prompt.
 * 
 * Results: None.
 * 
 * Side effects: A prompt gets output, and a Tcl script may be evaluated in
 * interp.
 * 
 * ----------------------------------------------------------------------
 */
static void
Prompt (interp, partial)
Tcl_Interp     *interp;					     /* Interpreter to use for prompting. */

int             partial;				     /* Non-zero means there already exists a partial command, so
							      * use the secondary prompt. */
{
  char           *promptCmd;

  int             code;

  promptCmd = Tcl_GetVar (interp,
			  partial ? "tcl_prompt2" : "tcl_prompt1", TCL_GLOBAL_ONLY);
  if (promptCmd == NULL) {
  defaultPrompt:
    if (!partial) {
      fputs ("% ", stdout);
    }
  } else {
    code = Tcl_Eval (interp, promptCmd);
    if (code != TCL_OK) {
      Tcl_AddErrorInfo (interp,
			"\n    (script that generates prompt)");
      fprintf (stderr, "%s\n", interp->result);
      goto defaultPrompt;
    }
  }
  fflush (stdout);
}

/*
 * ----------------------------------------------------------------------
 * 
 * StdinProc --
 * 
 * This procedure is invoked by the event dispatcher whenever standard input
 * becomes readable.  It grabs the next line of input characters, adds them to
 * a command being assembled, and executes the command if it's complete.
 * 
 * Results: None.
 * 
 * Side effects: Could be almost arbitrary, depending on the command that's typed.
 * 
 * ----------------------------------------------------------------------
 */

/* ARGSUSED */
static void
StdinProc (clientData, mask)
ClientData      clientData;				     /* Not used. */

int             mask;					     /* Not used. */
{
  char            input[4000];

  static int      gotPartial = 0;

  char           *cmd;

  int             code,
    count;

  count = read (fileno (stdin), input, sizeof (input) - 1);
  if (count <= 0) {
    if (!gotPartial) {
      if (tty) {
	Tcl_Eval (interp, "exit");
	exit (6);
      } else {
	Tk_DeleteFileHandler (0);
      }
      return;
    } else {
      count = 0;
    }
  }
  cmd = Tcl_DStringAppend (&command, input, count);
  if (count != 0) {
    if ((input[count - 1] != '\n') && (input[count - 1] != ';')) {
      gotPartial = 1;
      goto prompt;
    }
    if (!Tcl_CommandComplete (cmd)) {
      gotPartial = 1;
      goto prompt;
    }
  }
  gotPartial = 0;

  /*
   * Disable the stdin file handler while evaluating the command;
   * otherwise if the command re-enters the event loop we might process
   * commands from stdin before the current command is finished.  Among
   * other things, this will trash the text of the command being
   * evaluated.
   */

  Tk_CreateFileHandler (0, 0, StdinProc, (ClientData) 0);
  code = Tcl_RecordAndEval (interp, cmd, 0);
  Tk_CreateFileHandler (0, TK_READABLE, StdinProc, (ClientData) 0);
  Tcl_DStringFree (&command);
  if (*interp->result != 0) {
    if ((code != TCL_OK) || (tty)) {
      printf ("%s\n", interp->result);
    }
  }

  /*
   * Output a prompt.
   */
prompt:
  if (tty)
    Prompt (interp, gotPartial);
}

int dd_init_cmd(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
  dd_done();
  printf("dd_done is done!\n");
  init_dd();
  return TCL_OK;
}

main(int argc,char **argv){

  int status;
  char *name;
  char pidc[10];
  static int once = 0;
  Tk_Window main;
  time_t start=time(NULL);
  char           *args,
    *obj,
    *p;
  char            buf[20];
  host             = getenv("HOST");
  pid                = getpid();

  interp = Tcl_CreateInterp();
  
  Tcl_InitMemory(interp);

  if (Tk_ParseArgv(interp, (Tk_Window) NULL, &argc, argv, argTable, 0)
      != TCL_OK) {
    fprintf(stderr, "%s\n", interp->result);
    return(1);
  }
  
  /*
   * Initialize the Tk application.
   */

  mainWindow = Tk_CreateMainWindow(interp, display, "CODA monitor", "Tk");
  if (mainWindow == NULL) {
    fprintf(stderr, "%s\n", interp->result);
    exit(1);
  }
  Tk_GeometryRequest(mainWindow, 200, 200);
  tty = isatty(0);
  Tcl_SetVar(interp, "tcl_interactive",
	     (tty) ? "1" : "0", TCL_GLOBAL_ONLY);
  /*
   * Make command-line arguments available in the Tcl variables "argc"
   * and "argv".  Also set the "geometry" variable from the geometry
   * specified on the command line.
   */
  args = Tcl_Merge (argc - 1, argv + 1);
  Tcl_SetVar (interp, "argv", args, TCL_GLOBAL_ONLY);
  ckfree (args);
  sprintf (buf, "%d", argc - 1);
  Tcl_SetVar (interp, "argc", buf, TCL_GLOBAL_ONLY);
  Tcl_SetVar (interp, "argv0", argv[0], TCL_GLOBAL_ONLY);
  /*
   * Invoke application-specific initialization.
   */
  
  main = Tk_MainWindow(interp);
  
  /*
   * Call the init procedures for included packages.  Each call should
   * look like this:
   *
   * if (Mod_Init(interp) == TCL_ERROR) {
   *     return TCL_ERROR;
   * }
   *
   * where "Mod" is the name of the module.
   */
  if (Tcl_Init(interp) == TCL_ERROR) {
    printf("Tcl_Init error: %s\n",interp->result);
    return TCL_ERROR;
  }

  if (Itcl_Init(interp) == TCL_ERROR) {
    printf("Itcl_Init error: %s\n",interp->result);
    return TCL_ERROR;
  }

  if( Tk_Init(interp) == TCL_ERROR) {
    printf("Tk_Init error: %s\n",interp->result);
    return TCL_ERROR;
  }

  if (Tix_Init (interp) == TCL_ERROR) {
    printf("Tix_Init error: %s\n",interp->result);
    return TCL_ERROR;
  }

  if (Itk_Init(interp) == TCL_ERROR) {
    printf("Itk_Init error: %s\n",interp->result);
    return TCL_ERROR;
  }

  if (Blt_Init(interp) == TCL_ERROR) {
    printf("Blt_Init error: %s\n",interp->result);
    return TCL_ERROR;
  }

  if (Tdp_Init(interp) == TCL_ERROR) {
    printf("Tdp_Init error: %s\n",interp->result);
    return TCL_ERROR;
  }
 
  if (Svipc_Init (interp) == TCL_ERROR) {
    printf("Svipc_Init error: %s\n",interp->result);
    return TCL_ERROR;
  }
 
  if (MSQL_Init (interp) == TCL_ERROR) {
    printf("MSQL_Init error: %s\n",interp->result);
    return TCL_ERROR;
  }
 
  if (Struct_Init (interp) == TCL_ERROR) {
    printf("Struct_Init error: %s\n",interp->result);
    return TCL_ERROR;
  }
#ifndef LINUX
  if (Cdev_Init(interp) == TCL_ERROR) {
    printf("Cdev_Init error: %s\n",interp->result);
    return TCL_ERROR;
  }
#endif


  /*
   * Call Tcl_CreateCommand for application-specific commands, if
   * they weren't already created by the init procedures called above.
   */ 
 
  if (Dialog_Init(interp) == TCL_ERROR) {
    printf("error %s\n",interp->result);
    return TCL_ERROR;
  }
  if (cmonitor_Init(interp) == TCL_ERROR) {
    printf("error %s\n",interp->result);
    return TCL_ERROR;
  }

  windowid = (char *) CODAGetAppWindow(Tk_Display(mainWindow),"ddmon_WINDOW");
  
  if (windowid == 0) {
    int ix;
    char tmp[200];
    sprintf(tmp,"t:%d ddmon",getpid());
    coda_send(Tk_Display(Tk_MainWindow(interp)),"RUNCONTROL",tmp);
    for (ix = 0;ix<5;ix++) {
      sleep(1);
      windowid = (char *) CODAGetAppWindow(Tk_Display(Tk_MainWindow(interp)),
					   "ddmon_WINDOW");
      if (windowid) break;
    }
  }
  if (windowid) {
    char temp[200];
    sprintf(temp,"0x%08x",windowid);
    if (Tcl_VarEval(interp,"Window show .;\n"
		    "Window show .monitor ",temp," ;\n;"
		    "main 0 {}",NULL)
	== TCL_ERROR) {
      printf("interp->result %s\n",interp->result);
    }
  } else {
    if (Tcl_VarEval(interp,"Window show .;\n"
		    "Window show .monitor;\n;"
		    "main 0 {}",NULL)
	== TCL_ERROR) {
      printf("interp->result %s\n",interp->result);
    }
  }

  if (procview_Init(interp) == TCL_ERROR) {
    printf("error %s\n",interp->result);
    return TCL_ERROR;
  }
  if (coda_monitor_Init(interp) == TCL_ERROR) {
    printf("error %s\n",interp->result);
    return TCL_ERROR;
  }

  /*Tcl_EvalFile(interp,"/usr/local/coda/2.0dev/common/lib/xmon/coda_monitor.tcl");*/
  
  printf("result %s\n",interp->result);
  /* get dd name...if null, use default */
  name=getenv("DD_NAME");
  if((name==NULL)||(strlen(name)<=0)){
    dd_name=DEF_DD_NAME;
  } else {
    dd_name=strdup(name);
  }
  
  /*tty = isatty (0);
  Tk_CreateFileHandler (0, TK_READABLE, StdinProc, (ClientData) 0);
  
  if (isatty (0))
    Prompt (interp, 0);*/
  
  Tcl_DStringInit (&command);
  
  /* initialize DD system (create DD and static fifos if master)*/
  init_dd();
  last_time = time(NULL);
  Tk_CreateTimerHandler (1000*check_time, (Tk_TimerProc *) print_dd_stats, (ClientData) NULL);

  Tcl_CreateCommand(interp, "dd_startup", dd_init_cmd, NULL, NULL);

  /* main loop...check that dd_system is still alive, broadcast dd stats, respond to IPC messages, etc.*/
  while (done==0){
    (void)Tk_DoOneEvent(0);
  }

  printf("here with %d\n",status);
  /* done...check for bad status and shut everything down*/
  if(status=-1){
    printf("...bad status from ddu_attached: %d\n",status);
  }
  dd_done();
  exit(EXIT_SUCCESS);

}
   
void init_dd(){
  
  struct fifo_mode fmode;
  int ctl[FIFO_HDR_CTL_LEN]={0,0,0,0};
  char ftype[5];
  int status;
  
  
  /* create dd system if master, otherwise just attach;  die on failure */
  if(master!=0){
    if((status=dds_create())!=0){
      printf("unable to create dd system, status = %d\n",status);
      return;
    }
  } else if((status=ddu_attach())!=0){
    printf("unable to attach to dd system, status =%d \n",status);
    return;
  }
  

  /* create tape fifo if master and flag set */
  if((master!=0)&&(tape_fifo!=0)){
    if(ddu_fifo_exist("TAPE")==-1){
      fmode.mode     = FMODE_ALL;
      fmode.prescale = FMODE_NOPRESCALE;
      fmode.wait     = FWAIT_SLEEP;
      fmode.suser    = FMODE_MULTI_USER;
      fmode.p2ctl    = ctl;
      sprintf(ftype,"STA%2i",1);
      if ((status=fifo_make("TAPE",ftype, fmode)) != 1){
	printf("unable to create TAPE fifo \n");
	exit(EXIT_FAILURE);
      }
      if (fifo_set_status(1,FSTAT_IDLE)){
	printf("cannot activate TAPE fifo \n");
	exit(EXIT_FAILURE);
      }
    } else {
      printf("TAPE fifo already exists!\n");
    }
  }
  
  
  /* create scaler fifo if master */
  if((master!=0)&&(scaler_fifo!=0)){
    if(ddu_fifo_exist("SCALER")==-1) {
      fmode.mode     = FMODE_COND;
      fmode.prescale = FMODE_NOPRESCALE;
      fmode.wait     = FWAIT_SLEEP;
      fmode.suser    = FMODE_MULTI_USER;
      ctl[0]=0x10;
      fmode.p2ctl    = ctl;
      sprintf(ftype,"STA%2i",scaler_fifo_num);
      if ((status=fifo_make(scaler_fifo_name,ftype, fmode)) != scaler_fifo_num){
	printf("unable to create fifo %s\n",scaler_fifo_name);
	exit(EXIT_FAILURE);
      }
      if (fifo_set_status(scaler_fifo_num,FSTAT_IDLE)){
	printf("cannot activate fifo %s, num %d\n",scaler_fifo_name,scaler_fifo_num);
	exit(EXIT_FAILURE);
      }
    } else {
      printf("SCALER fifo already exists!\n");
    }
  }

  return;
}

void
tclprintf (char *tag,char *fmt,...)
{
  va_list ap;
  char temp[2000];
  int ix_end;
  va_start(ap,);
  vsprintf (temp, fmt,ap);
  if (Tcl_VarEval(interp,"expr int([.monitor.top.cpd27.03 index end])",NULL)
      == TCL_ERROR) {
    printf("interp->result %s\n",interp->result);
  }
  ix_end = atoi(interp->result)-1;
  if (Tcl_VarEval(interp,".monitor.top.cpd27.03 insert end \"",temp,"\"",NULL)
      == TCL_ERROR) {
    printf("interp->result %s\n",interp->result);
  }
  {
    char *p1,*p2;
    int i,j,k,cnt,ocnt;
    char tmp[100];
    p1=fmt;

    cnt = ocnt = 0;
    while (*p1) {
      if (*p1=='%') {
	sprintf(temp,".monitor.top.cpd27.03 tag add none %d.%d %d.%d",
		ix_end,
		ocnt,
		ix_end,
		cnt);
	if (Tcl_VarEval(interp,temp,NULL)
	    == TCL_ERROR) {
	  printf("interp->result %s\n",interp->result);
	}
	ocnt = cnt;
	p2 = p1+1;
	if (*p2 == '-')
	  p2++;
	i = 0;
	while (isdigit(*p2)) {
	  tmp[i++] = *p2++;
	}
	tmp[i]=0;
	j = atoi(tmp);
	p1=p2;
	cnt += j-1;
	sprintf(temp,".monitor.top.cpd27.03 tag add %s %d.%d %d.%d",
		tag,
		ix_end,
		ocnt,
		ix_end,
		cnt+1);
	if (Tcl_VarEval(interp,temp,NULL)
	    == TCL_ERROR) {
	  printf("interp->result %s\n",interp->result);
	}
	ocnt=cnt;
      }
      cnt++;
      p1++;
    }
  }
}

void
tclflush()
{
  if (Tcl_VarEval(interp,".monitor.top.cpd27.03 delete 1.0 end ",NULL)
      == TCL_ERROR) {
    printf("interp->result %s\n",interp->result);
  }
}

void print_dd_stats(void)
{
  static int oldin[MAX_FIFO_NB_MAX], oldout[MAX_FIFO_NB_MAX];
  int  cnt[MAX_FIFO_NB_MAX];
  double ratein[MAX_FIFO_NB_MAX], rateout[MAX_FIFO_NB_MAX];
  char temp[256],fifo_text[50];
  int fstatus[MAX_FIFO_NB_MAX];
  int fcnt[MAX_FIFO_NB_MAX];
  int devin[MAX_FIFO_NB_MAX];
  int devout[MAX_FIFO_NB_MAX];
  int evnb[MAX_FIFO_NB_MAX];
  time_t now=time(NULL);
  int deltat;
  char *t;
  int i,status,tlen;

  if(dd_dcom==NULL){ 
    if(master!=0){
      init_dd();
      Tcl_Eval(interp, "chartzero");
    }

    Tcl_Eval(interp, "dd.obj setState down");
    goto end;
  }

  if((status=ddu_attached())<=0){
    printf("print_dd_stats...bad status from ddu_attached: %d\n",status);
    Tcl_Eval(interp, "dd.obj setState down");
    goto end;
  }

  if ( Tcl_Eval(interp, ".monitor.top config") != TCL_OK) {
    printf("toplevel window has gone: exit\n");
    exit (0);
  }

  deltat=(int)(now-last_time);
  last_time=now;

  fifo_rate(fstatus,fcnt,devin,devout);
  t=ctime(&now);
  
  tclflush();
  t[strlen(t)-1]='\0';
  tclprintf("title","%11s%8s%6s%6d%7s%7s\n%7s%25s\n",
	    "DD system: ",
	    dd_name,
	    " pid: ",
	    pid,
	    " host: ",
	    host,
	    " time: ",
	    t);
  
  tclprintf("none","\n");
  
  tclprintf("subtitle","%9s %6s %5s %8s %8s %9s %8s\n", 
	    "DD status",
	    "nmstr",
	    "nproc",
	    "max_fifo",
	    "nfev_req",
	    "nbuf_made",
	    "nbuf_vol");
  
  tclprintf("data",    "%9d %6d %5d %8d %8d %9d %8d\n", 
	    dd_dcom->dd_status,
	    dd_dcom->dd_nmstr,
	    dd_dcom->dd_nproc_att,
	    dd_dcom->fifo_max_in_use,
	    dd_dcom->nfev_req,
	    dd_dcom->nbuf_vol_made,
	    dd_dcom->db_nbuf_vol);
  tclprintf("data","\n");
  
  tclprintf("subtitle", "%-10s %3s %5s\n",
	    "Master PID",
	    "sem",
	    "semval");
  
  for (i=0; i<dd_dcom->dd_nmstr; i++) {
    tclprintf("data","%10d %3d %5d\n",
	      dd_dcom->dd_master[i].pid,
	      dd_dcom->dd_master[i].dd_sem ,
	      dd_dcom->dd_master[i].dd_semval);
  }

  tclprintf("data","\n");
  
  tclprintf("subtitle","%11s %10s %7s %9s %9s\n",
	    "max_fifo_nb",
	    "fifo_depth",
	    "maxnbev",
	    "maxevsize",
	    "maxbufvol");
  
  tclprintf("data",    "%11d %10d %7d %9d %9d\n\n",
	    dd_dcom->dd_config.max_fifo_nb ,
	    dd_dcom->dd_config.fifo_depth,
	    dd_dcom->dd_config.db_maxnbev,
	    dd_dcom->dd_config.db_maxevsize,
	    dd_dcom->dd_config.db_max_buf_vol);
  
  tclprintf("subtitle","%17s %6s %4s %4s %6s %6s %9s %9s\n",
	    "process",
	    "PID",
	    "fifo",
	    "wait",
	    "status",
	    "master",
	    "evput",
	    "evget");
  for (i=0; i<dd_dcom->dd_nproc_att; i++){
    tlen=strlen(dd_dcom->dd_proc[i].pname)<28?strlen(dd_dcom->dd_proc[i].pname):28;
    strncpy(temp,dd_dcom->dd_proc[i].pname,tlen);
    temp[tlen]=NULL;
    tclprintf("data",  "%17s %6d %4d %4d %6d %6d %9d %9d\n",
	      temp,
	      dd_dcom->dd_proc[i].pid,
	      dd_dcom->dd_proc[i].fifo,
	      dd_dcom->dd_proc[i].dd_wait,
	      dd_dcom->dd_proc[i].status,
	      dd_dcom->dd_proc[i].master_id,
	      dd_dcom->dd_proc[i].nputfev,
	      dd_dcom->dd_proc[i].ngetfev);
  }
  tclprintf("data","\n");
  
  tclprintf("subtitle","%11s %7s %6s %8s %5s %28s\n",
	    "DD_name",
	    "creator",
	    "status",
	    "max_fifo",
	    "depth",
	    "create time");

  tclprintf("data","%11s %7d %6d %8d %5d %28s\n",
	    fifo_sys_start->sys_name,
	    fifo_sys_start->pid_creat,
	    fifo_sys_start->status,
	    fifo_sys_start->max_fifo_nb,
	    fifo_sys_start->fifo_depth,
	    ctime(&fifo_sys_start->time_creat));
  
  tclprintf("subtitle","%6s %3s %4s %4s %4s %4s %4s %4s %3s %5s %3s %5s %5s\n",
	    "name",
	    "num",
	    "type",
	    "stat",
	    "mode",
	    "proc",
	    "wait",
	    "freq",
	    "pre",
	    "pid",
	    "sem",
	    "rin",
	    "rout");
  
  for(i=0; i<fifo_sys_start->max_fifo_nb; i++){
    struct a_fifo *pp;
    pp=fifo_shm_start +i;
    status=pp->fhdr.fstatus;
    if(fstatus[i]!=0){
      tclprintf("data","%6s %3d %4s %4d %4d %4d %4d %4d %3d %5d %3d %5d %5d\n",
		pp->fhdr.fname,
		pp->fhdr.fnumber,
		pp->fhdr.ftype,
		pp->fhdr.fstatus,
		pp->fhdr.fmode,
		pp->fhdr.fnproc_att,
		pp->fhdr.fwait_mode,
		pp->fhdr.freqcnt,
		pp->fhdr.fprescale,
		pp->fhdr.fpidcreat ,
		fcnt[i],
		devin[i]/deltat,
		devout[i]/deltat);
      
      sprintf(temp,"graphplot .monitor.top.graphs.cpd34 %d %d",i,fcnt[i]);
      
      if ( Tcl_Eval(interp, temp) != TCL_OK)
	return;
      evnb[i] = pp->nopout;
      ratein[i]  = devin[i] /1000.0 /deltat;
      rateout[i] = devout[i]/ 1000.0 /deltat;
      
      sprintf(temp,"graphplot  .monitor.top.graphs.cpd36 %d %f",i,ratein[i]);
      if ( Tcl_Eval(interp, temp) != TCL_OK)
	return;
      
      sprintf(fifo_text,"\"%4i %4i %4i\"",
	      ratein[i],
	      rateout[i],
	      cnt[i]);
      
      sprintf(temp,"%d",i);
      
      if( Tcl_VarEval(interp, "graphlabel .monitor.top.graphs.cpd34 ",
		      temp,
		      " ",
		      pp->fhdr.fname, NULL) != TCL_OK)
	return;
      
      if( Tcl_VarEval(interp, "graphlabel  .monitor.top.graphs.cpd36 ",
		      temp,
		      " ",
		      pp->fhdr.fname, NULL) != TCL_OK)
	return;
      
      oldin[i] = devin[i];
      oldout[i] = devout[i];
      sprintf(temp,"chartplot fifo%d %d %f",i,deltat,ratein[i]);
      Tcl_Eval(interp, temp);
    } else {
      sprintf(temp,"chartplot fifo%d %d %f",i,deltat,0);
      Tcl_Eval(interp, temp);
    }
  }

  tclprintf("data","\n"); 

  Tcl_Eval(interp, "dd.obj setState up");
  sprintf(temp,"dd.obj setText3 \"%-5s%8d\n%-5s%8d\n\"",
	  "evnb",
	  evnb[0],
	  "ev/s",
	  devout[0]/deltat);

  Tcl_Eval(interp,temp);
end:
  /*sprintf(temp,"monitor monitor_callback");
    if(Tcl_Eval(interp, temp) != TCL_OK) {
    }
    sprintf(temp," MainWin::loop");
    if(Tcl_Eval(interp, temp) != TCL_OK) {
    }*/
  Tk_CreateTimerHandler (1000*check_time, (Tk_TimerProc *) print_dd_stats, (ClientData) NULL);
  return;
}

void dd_done(void){

  time_t endtime=time(NULL);

  if(master!=0){
    dds_close(0);
  } else {
    ddu_close();
  }

  return;
}

