#include <stdio.h>
#include <rpc/rpc.h>
#include "tsRpc.h"

static void tssrvr_1();

main()
{
	SVCXPRT *transp;

	(void)pmap_unset(TSSRVR, TSVERS);

	transp = svctcp_create(RPC_ANYSOCK, 0, 0);
	if (transp == NULL) {
		(void)fprintf(stderr, "cannot create tcp service.\n");
		exit(1);
	}
	if (!svc_register(transp, TSSRVR, TSVERS, tssrvr_1, IPPROTO_TCP)) {
		(void)fprintf(stderr, "unable to register (TSSRVR, TSVERS, tcp).\n");
		exit(1);
	}
	svc_run();
	(void)fprintf(stderr, "svc_run returned\n");
	exit(1);
}

static void
tssrvr_1(rqstp, transp)
	struct svc_req *rqstp;
	SVCXPRT *transp;
{
	union {
		TS_AF ts_rpctsinit1_1_arg;
		int ts_rpctscsr_1_arg;
		int ts_rpctstrig_1_arg;
		TS_4CHAR ts_rpctsroc_1_arg;
		int ts_rpctssync_1_arg;
		TS_NV ts_rpctsprescale_1_arg;
		TS_NV ts_rpctstimer_1_arg;
		TS_NV ts_rpctsmemory_1_arg;
		int ts_rpctsgo_1_arg;
		int ts_rpctsstop_1_arg;
		int ts_rpctsinit_1_arg;
		TS_RN ts_rpctsread_1_arg;
		TS_RNV ts_rpctswrite_1_arg;
		int ts_rpctstimerstatus_1_arg;
		int ts_rpctstriggerstatus_1_arg;
		int ts_rpctsstatus_1_arg;
		int ts_rpctsstate_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();

	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void)svc_sendreply(transp, xdr_void, (char *)NULL);
		return;

	case TS_RPCTSINIT1:
		xdr_argument = xdr_TS_AF;
		xdr_result = xdr_int;
		local = (char *(*)()) ts_rpctsinit1_1;
		break;

	case TS_RPCTSMEMINIT:
		xdr_argument = xdr_void;
		xdr_result = xdr_int;
		local = (char *(*)()) ts_rpctsmeminit_1;
		break;

	case TS_RPCTSCSR:
		xdr_argument = xdr_int;
		xdr_result = xdr_int;
		local = (char *(*)()) ts_rpctscsr_1;
		break;

	case TS_RPCTSTRIG:
		xdr_argument = xdr_int;
		xdr_result = xdr_int;
		local = (char *(*)()) ts_rpctstrig_1;
		break;

	case TS_RPCTSROC:
		xdr_argument = xdr_TS_4CHAR;
		xdr_result = xdr_int;
		local = (char *(*)()) ts_rpctsroc_1;
		break;

	case TS_RPCTSSYNC:
		xdr_argument = xdr_int;
		xdr_result = xdr_int;
		local = (char *(*)()) ts_rpctssync_1;
		break;

	case TS_RPCTSPRESCALE:
		xdr_argument = xdr_TS_NV;
		xdr_result = xdr_int;
		local = (char *(*)()) ts_rpctsprescale_1;
		break;

	case TS_RPCTSTIMER:
		xdr_argument = xdr_TS_NV;
		xdr_result = xdr_int;
		local = (char *(*)()) ts_rpctstimer_1;
		break;

	case TS_RPCTSMEMORY:
		xdr_argument = xdr_TS_NV;
		xdr_result = xdr_int;
		local = (char *(*)()) ts_rpctsmemory_1;
		break;

	case TS_RPCTSGO:
		xdr_argument = xdr_int;
		xdr_result = xdr_void;
		local = (char *(*)()) ts_rpctsgo_1;
		break;

	case TS_RPCTSSTOP:
		xdr_argument = xdr_int;
		xdr_result = xdr_void;
		local = (char *(*)()) ts_rpctsstop_1;
		break;

	case TS_RPCTSINIT:
		xdr_argument = xdr_int;
		xdr_result = xdr_void;
		local = (char *(*)()) ts_rpctsinit_1;
		break;

	case TS_RPCTSREAD:
		xdr_argument = xdr_TS_RN;
		xdr_result = xdr_int;
		local = (char *(*)()) ts_rpctsread_1;
		break;

	case TS_RPCTSWRITE:
		xdr_argument = xdr_TS_RNV;
		xdr_result = xdr_int;
		local = (char *(*)()) ts_rpctswrite_1;
		break;

	case TS_RPCTSTIMERSTATUS:
		xdr_argument = xdr_int;
		xdr_result = xdr_void;
		local = (char *(*)()) ts_rpctstimerstatus_1;
		break;

	case TS_RPCTSTRIGGERSTATUS:
		xdr_argument = xdr_int;
		xdr_result = xdr_void;
		local = (char *(*)()) ts_rpctstriggerstatus_1;
		break;

	case TS_RPCTSSTATUS:
		xdr_argument = xdr_int;
		xdr_result = xdr_int;
		local = (char *(*)()) ts_rpctsstatus_1;
		break;

	case TS_RPCTSSTATE:
		xdr_argument = xdr_int;
		xdr_result = xdr_int;
		local = (char *(*)()) ts_rpctsstate_1;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	bzero((char *)&argument, sizeof(argument));
	if (!svc_getargs(transp, xdr_argument, &argument)) {
		svcerr_decode(transp);
		return;
	}
	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, result)) {
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, xdr_argument, &argument)) {
		(void)fprintf(stderr, "unable to free arguments\n");
		exit(1);
	}
}

