/* ----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	TS rpc definitions
 *	
 * Author:  David Abbott, CEBAF Data Acquisition Group
 *
 */

struct TS_AF {
    int laddr;
    int iflag;
};

struct TS_4CHAR {
    unsigned char b4;
    unsigned char b3;
    unsigned char b2;
    unsigned char b1;
};

struct TS_NV {
    int Num;
    unsigned long val;
};

struct TS_RN {
    unsigned long Reg;
    int Num;
};

struct TS_RNV {
    unsigned long Reg;
    int Num;
    unsigned long Val;
};

program TSSRVR {
  version TSVERS {
    int TS_RPCTSINIT1(TS_AF)=1;
    int TS_RPCTSMEMINIT(void)=2;
    int TS_RPCTSCSR(int)=3;
    int TS_RPCTSTRIG(int)=4;
    int TS_RPCTSROC(TS_4CHAR)=5;
    int TS_RPCTSSYNC(int)=6;
    int TS_RPCTSPRESCALE(TS_NV)=7;
    int TS_RPCTSTIMER(TS_NV)=8;
    int TS_RPCTSMEMORY(TS_NV)=9;
    void TS_RPCTSGO(int)=10;
    void TS_RPCTSSTOP(int)=11;
    void TS_RPCTSINIT(int)=12;
    int TS_RPCTSREAD(TS_RN)=13;
    int TS_RPCTSWRITE(TS_RNV)=14;
    void TS_RPCTSTIMERSTATUS(int)=15;
    void TS_RPCTSTRIGGERSTATUS(int)=16;
    int TS_RPCTSSTATUS(int)=17;
    int TS_RPCTSSTATE(int)=18;
  } = 1;
} = 0x2c0da00a;