/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 * ------------
 *  RPC interface routines for CAMAC standard routines
 *  Both C and Fortran interfaces are provided. No LAM handling
 *	
 * Author:  David Abbott, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: tsClientLib.c,v $
 *   Revision 1.1  2000/08/17 19:22:38  abbottd
 *   Initial Revision
 *
 */

#include <stdio.h>
#include <rpc/rpc.h>
#include "tsRpc.h"

CLIENT *tsHandle;

void tsopen(char *server,int *success)
{
  tsHandle = clnt_create(server,TSSRVR,TSVERS,"tcp");
  if (tsHandle == NULL) {
    (void) clnt_pcreateerror(server);
    *success=0;
  }
  else
    *success=1;
}
void tsopen_(char *server,int *success,int server_len)
{
  char *s;
  s = (char *) malloc(server_len+1);
  strncpy(s,server,server_len);
  s[server_len]=0;		/* make null terminated string */
  (void) tsopen(s,success);
  free(s);
}


int 
ts_init_1 (unsigned long laddr, int iflag)
{
  TS_AF arg;
  int *r;
  arg.laddr = laddr;
  arg.iflag = iflag;
  r = ts_rpctsinit1_1(&arg,tsHandle);
  if (r != NULL)
    return(*r);
  else
    return(-1);
}

int 
tsMemInit()
{
  int *r;
  r = ts_rpctsmeminit_1(NULL,tsHandle);
  if (r != NULL)
    return(*r);
  else
    return(-1);
}

unsigned long 
tsCsr (unsigned long val)
{
  unsigned long arg;
  int *r;
  arg = val;
  r = ts_rpctscsr_1(&arg,tsHandle);
  if (r != NULL)
    return(*r);
  else
    return(0); 
}

unsigned long 
tsTrig (unsigned long val)
{
  unsigned long arg;
  int *r;
  arg = val;
  r = ts_rpctstrig_1(&arg,tsHandle);
  if (r != NULL)
    return(*r);
  else
    return(0); 
}

unsigned long 
tsRoc (unsigned char b4,unsigned char b3,unsigned char b2,unsigned char b1)
{
  TS_4CHAR arg;
  int *r;
  arg.b4 = b4;
  arg.b3 = b3;
  arg.b2 = b2;
  arg.b1 = b1;
  r = ts_rpctsroc_1(&arg,tsHandle);
  if (r != NULL)
    return(*r);
  else
    return(0); 
}

unsigned long 
tsSync (unsigned long val)
{
  unsigned long arg;
  int *r;
  arg = val;
  r = ts_rpctssync_1(&arg,tsHandle);
  if (r != NULL)
    return(*r);
  else
    return(0); 
}

unsigned long 
tsPrescale (int Num, unsigned long val)
{
  TS_NV arg;
  int *r;
  arg.Num = Num;
  arg.val = val;
  r = ts_rpctsprescale_1(&arg,tsHandle);
  if (r != NULL)
    return(*r);
  else
    return(-1);
}

unsigned long 
tsTimer (int Num, unsigned long val)
{
  TS_NV arg;
  int *r;
  arg.Num = Num;
  arg.val = val;
  r = ts_rpctstimer_1(&arg,tsHandle);
  if (r != NULL)
    return(*r);
  else
    return(-1);
}

unsigned long 
tsMemory (int Num, unsigned long val)
{
  TS_NV arg;
  int *r;
  arg.Num = Num;
  arg.val = val;
  r = ts_rpctsmemory_1(&arg,tsHandle);
  if (r != NULL)
    return(*r);
  else
    return(-1);
}

unsigned long 
tsRead (unsigned long Reg, int Num)
{
  TS_RN arg;
  int *r;
  arg.Reg = Reg;
  arg.Num = Num;
  r = ts_rpctsread_1(&arg,tsHandle);
  if (r != NULL)
    return(*r);
  else
    return(-1);
}
unsigned long 
tsWrite (unsigned long Reg, int Num, unsigned long Val)
{
  TS_RNV arg;
  int *r;
  arg.Reg = Reg;
  arg.Num = Num;
  arg.Val = Val;
  r = ts_rpctsread_1(&arg,tsHandle);
  if (r != NULL)
    return(*r);
  else
    return(-1);
}

unsigned long 
tsStatus (int iflag)
{
  int arg;
  int *r;
  arg = iflag;
  r = ts_rpctsstatus_1(&arg,tsHandle);
  if (r != NULL)
    return(*r);
  else
    return(0); 
}

unsigned long 
tsState (int iflag)
{
  int arg;
  int *r;
  arg = iflag;
  r = ts_rpctsstate_1(&arg,tsHandle);
  if (r != NULL)
    return(*r);
  else
    return(0); 
}

void
tsTimerStatus (int iflag)
{
  int arg;
  int *r;
  arg = iflag;
  r = ts_rpctstimerstatus_1(&arg,tsHandle);
}

void
tsTriggerStatus (unsigned long tmask)
{
  int arg;
  int *r;
  arg = tmask;
  r = ts_rpctstriggerstatus_1(&arg,tsHandle);
}

void
tsGo (int iflag)
{
  int arg;
  int *r;
  arg = iflag;
  r = ts_rpctsgo_1(&arg,tsHandle);
}

void
tsStop (int iflag)
{
  int arg;
  int *r;
  arg = iflag;
  r = ts_rpctsstop_1(&arg,tsHandle);
}

void
tsInit (int iflag)
{
  int arg;
  int *r;
  arg = iflag;
  r = ts_rpctsinit_1(&arg,tsHandle);
}

