/*
 *	ts.h
 *
 * Header file for CEBAF trigger supervisor definitions
 *
 */

#define DA_CREATED 0
#define DA_DOWNLOADED 1
#define DA_PAUSED 2
#define DA_ACTIVE 3
#define DA_FATAL 4

#define TS_TICKS_TO_STOP 60

typedef struct tsdbstruct {
  char *name;
  int number;
} TS_DATABASE;

typedef struct tsstruct {
  int csr;
  int ena;			/* 0 = common, 1-12 = inputs, 15 = open all */
  int rocena;			/* 0:7 = branch 1, etc */
  int sync;			/* sync interval, must be enabled in csr */
  int test;			/* sets up simulation conditions */
  int state;			/* reads internal state of sequencer */
  int fill1[2];
  int prescale[8];
  int cptimer;			/* clear permit timer */
  int l2timer;			/* level 2 timer */
  int l3timer;			/* level 3 timer */
  int fbtimer;			/* front-end busy timer */
  int chtimer;			/* clear hold timer */
  int fill2[4];
  int sca1assign;		/* scaler 1 assignment control */
  int sca0in;			/* scaler 0 independent */
  int sca1in;			/* scaler 1 independent */
  int fill3;
  int sca0;			/* scaler 0, latch 0&1 */
  int sca1;			/* scaler 1, latched on last sca0 read/write */
  int fill4[4065];		/* round up to 4096 ints (0x4000 bytes) */
  int mlu[4096];		/* addressed by 12 bit trigger pattern */
} TRIGGER_SUPERVISOR;

typedef struct tsmlustruct {
  unsigned int l1ok  :1;	/* bit 0 */
  unsigned int class :3;
  unsigned int code  :4;
  unsigned int accept:8;
} TS_MLU_ENTRY;

#define TS_RPN_SETT 1
#define TS_RPN_GET  2
#define TS_RPN_NEG  3
#define TS_RPN_OR   4
#define TS_RPN_AND  5
#define TS_RPN_EVAL 6

/* CSR bit mask definitions */

#define TS_GO 1
#define TS_ENA_POS 2
#define TS_ENA_PNS 4
#define TS_ENA_SYNC 8
#define TS_SYNC 0x10
#define TS_ENA_LV1 0x20
#define TS_ENA_CPTIMER 0x40
#define TS_ENA_FBTIMER 0x80
#define TS_ENA_CHTIMER 0x100
#define TS_ENA_RLOCK 0x200
#define TS_ENA_RLOCK4 0x400
#define TS_DIS_INH 0x800
#define TS_HOLD 0x1000
#define TS_TEST 0x2000
#define TS_RESET 0x4000
#define TS_INIT 0x8000

#define TS_STOP 0x10000
#define TS_DIS_POS 0x20000
#define TS_DIS_PNS 0x40000
#define TS_DIS_SYNC 0x80000
#define TS_REL_SYNC 0x100000
#define TS_DIS_LV1 0x200000
#define TS_DIS_CPTIMER 0x400000
#define TS_DIS_FBTIMER 0x800000
#define TS_DIS_CHTIMER 0x1000000
#define TS_DIS_RLOCK 0x2000000
#define TS_DIS_RLOCK4 0x4000000
#define TS_ENA_INH 0x8000000
#define TS_REL_HOLD 0x10000000
#define TS_REL_TEST 0x20000000

#define TS_INHIBIT_OCCURED 0x10000
#define TS_LATE_FAIL 0x20000
#define TS_SYNC_OCCURED 0x40000
#define TS_WRITE_ERROR 0x80000
#define TS_READ_ERROR 0x100000
#define TS_VME_ERROR 0x200000

/* enable register bit definitions */

#define TS_STROBE 0
#define TS_OPEN  15

/* mlu bit definitions */

#define TS_MLU_L1OK 1
#define TS_MLU_TC1 2
#define TS_MLU_TC2 4
#define TS_MLU_TC3 8
#define TS_MLU_TC  0xE
#define TS_MLU_RC0 0x10
#define TS_MLU_RC1 0x20
#define TS_MLU_RC2 0x40
#define TS_MLU_RC3 0x80
#define TS_MLU_RC  0xF0
#define TS_MLU_L1A 0xFF00

/* test register bits */

#define TS_TR_L1PASS 1		/* 0xFF are strobes */
#define TS_TR_L2PASS 2
#define TS_TR_L3PASS 4
#define TS_TR_L2FAIL 8
#define TS_TR_L3FAIL 0x10
#define TS_TR_STEP 0x80
#define TS_TR_BUSY 0x100	/* 0xFF00 are read/write states */
#define TS_TR_INH 0x200
#define TS_TR_B1ACK 0x400
#define TS_TR_B2ACK 0x800
#define TS_TR_B3ACK 0x1000
#define TS_TR_B4ACK 0x2000
#define TS_TR_ERTACK 0x4000

/* scaler 1 control options */

#define TS_SCA1_PRE 0
#define TS_SCA1_PRE1 1		/* 1-12 == prescaled inputs 1-12 */
#define TS_SCA1_LATCHED 0xD
#define TS_SCA1_L1ACCEPT 0xE
#define TS_SCA1_FAST_RESET 0xF
#define TS_SCA1_CLEAR 0x10
#define TS_SCA1_L2FAIL 0x20
#define TS_SCA1_L3FAIL 0x30
#define TS_SCA1_LATE 0x40
#define TS_SCA1_SYNC 0x50

#define bittest(a,i) ((a)&(1<<i))
#define bitset(a,i) ((a)=(a)|(1<<i))
#define bitclear(a,i) ((a)=(a)&(-1-(1<<i)))
