#!/bin/sh
#\
exec $CODA_BIN/dpwish -f "$0"
#

global vme
global line1 line2 line3 line4

set title "TSP"
wm title . $title
wm minsize . 60 4

set vme "dafarm03"
set line1 " Click on STATUS "
set line2 "to connect to the"
set line3 "  TS and return  "
set line4 "its current state"

#------------------------------------------------------------

proc print { } {

global line1 line2 line3 line4

    .field.name.name1 config -text $line1 \
	    -padx 10 -anchor e
    .field.name.name2 config -text $line2 \
	    -padx 10 -anchor e
    .field.name.name3 config -text $line3 \
	    -padx 10 -anchor e
    .field.name.name4 config -text $line4 \
	    -padx 10 -anchor e

}

#------------------------------------------------------------

proc status { } {
    
    global vme
    global stat
    global line1 line2 line3 line4

    exec tsp $vme status > ts.stat

    set file1 "ts.stat"

    if [catch {open $file1 r+} FileId] {
	exit
    } else {
	set FileId [open $file1 r+]
    }
    
    gets $FileId line1
    gets $FileId line2
    gets $FileId line3
    gets $FileId line4

    close $FileId
    print
}

#--------------------------------------------------------------

  frame .menu \
    -relief raised \
    -bg gray50\
    -bd 2
    
  menubutton .menu.file \
    -text "FILE" \
    -bg gray50\
    -underline 0 \
    -activebackground white \
    -activeforeground black \
    -menu .menu.file.menu
  
  menu .menu.file.menu \
    -bg gray50\
    -activebackground white \
    -activeforeground black 
 
  .menu.file.menu add command \
    -label "Exit" -underline 0 -command "destroy ."

  menubutton .menu.vme \
    -text "SELECT VME" \
    -bg gray50\
    -underline 0 \
    -activebackground white \
    -activeforeground black \
    -menu .menu.vme.menu
  
  menu .menu.vme.menu \
    -bg gray50\
    -activebackground white \
    -activeforeground black 

  .menu.vme.menu add command \
    -label "SELECT HOST" -underline 0 -command "select"

  pack .menu \
   -in .  \
   -side top \
   -expand 1\
   -fill x
  
  pack .menu.file \
    -side left \
    -in .menu

  pack .menu.vme \
    -side left \
    -in .menu  

frame .buttons -borderwidth 4 -relief ridge -bg gray50
pack .buttons -side top -expand true -fill both
button .buttons.status -bg gray100 -fg black -text "STATUS" -command "status"
button .buttons.pause -bg red -fg black -text "DISABLE" -command "pause"
button .buttons.go -bg green -fg black -text "ENABLE"  -command "go"
pack .buttons.status -side left
pack .buttons.pause -side left
pack .buttons.go -side left 

frame .field  -bg gray50 -borderwidth 10
pack .field -side bottom -expand true -fill both
frame .field.name -bg Red
pack .field.name -side left -fill y -expand true

label .field.name.name1 -width 15 -anchor e -padx 2 -bg gray50 \
	    -fg white
pack .field.name.name1 -side top -expand true

label .field.name.name2 -width 15 -anchor e -padx 2 -bg gray50 \
	    -fg white
pack .field.name.name2 -side top -expand true

label .field.name.name3 -width 15 -anchor e -padx 2 -bg gray50 \
	    -fg white
pack .field.name.name3 -side top -expand true

label .field.name.name4 -width 15 -anchor e -padx 2 -bg gray50 \
	    -fg white
pack .field.name.name4 -side top -expand true

print

#--------------------------------------------------------------

proc select { } {

    global vme tmpvme

    toplevel    .select
    wm title    .select "SELECT VME"
    
    set tmpvme $vme

    frame .select.field1  -bg Red -borderwidth 10
    pack .select.field1 -side bottom -expand true -fill both
    frame .select.field1.name -bg Red
    pack .select.field1.name -side left -fill y -expand true
    frame .select.field1.value -bg Red
    pack .select.field1.value -side right -fill y -expand true

    .select configure -bg Red 

  frame .select.menu1 \
    -relief raised \
    -bg gray50\
    -bd 2
    
  menubutton .select.menu1.file \
    -text "File" \
    -bg gray50\
    -underline 0 \
    -activebackground white \
    -activeforeground black \
    -menu .select.menu1.file.menu
  
  menu .select.menu1.file.menu \
    -bg gray50\
    -activebackground white \
    -activeforeground black 
 
  .select.menu1.file.menu add command \
    -label "Exit" -underline 0 -command "destroy .select"

  pack .select.menu1 \
   -in .select  \
   -side top \
   -expand 1\
   -fill x
  
  pack .select.menu1.file \
    -side left \
    -in .select.menu1

    label .select.field1.name.name1 -width 15 -anchor e -padx 2 -bg Red \
	    -fg black

    entry .select.field1.value.value1 -relief sunken -width 12 -bg LightGrey\
            -fg black -textvariable tmpvme


	pack .select.field1.name.name1 -side top -expand true
	pack .select.field1.value.value1 -side top -expand true

    bind .select.field1.value.value1 <Return> { set vme $tmpvme }

    .select.field1.name.name1 config -text "VME TS" -padx 10 -anchor e


}


#--------------------------------------------------------------

proc pause { } {

    global vme

    exec tsp $vme disable
    status

}

#--------------------------------------------------------------

proc go { } {
    
    global vme
    
    exec tsp $vme enable
    status
}
