/*
 *	tclSQL.h	- Definitions
 *
 * Copyright (c) 1994   Brad Pepers
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * This software is provided "as is" without any expressed or implied
 * warranty.
 *
 * $Id: tclSQL.h,v 1.1.1.1 1996/09/05 14:29:47 heyes Exp $
 *
 * $Log: tclSQL.h,v $
 * Revision 1.1.1.1  1996/09/05 14:29:47  heyes
 * Initial Import
 *
 * Revision 1.5  1994/08/25  00:28:10  pepers
 * Changed for mSQL version 0.2
 *
 * Revision 1.4  1994/07/28  22:44:45  pepers
 * Changed around how commands work
 *
 * Revision 1.3  1994/07/28  02:04:58  pepers
 * Changed close command to disconnect
 *
 * Revision 1.2  1994/07/27  22:43:24  pepers
 * Fixed log files
 *
 * Revision 1.1  1994/07/27  22:34:58  pepers
 * First version of mSQL to Tcl/Tk interface
 *
*/

#include <stdio.h>
#include <tcl.h>
#include <msql.h>

typedef struct msqlConnS msqlConn;

typedef struct msqlConnS {
  msqlConn *next;
  char name[80];
  char *host;
  int socket;
  char database[100];
  m_result *query_result;
} msqlConns;


extern void MSQL_Init(Tcl_Interp *interp);
extern void MSQL_Cleanup(void);

extern int MSQL_Cmd(ClientData clientData, Tcl_Interp *interp, int argc,
		   char **argv);
extern int MSQL_Conn_Cmd(ClientData clientData, Tcl_Interp *interp,
			   int argc, char **argv);

extern int MSQL_Cmd_Disconnect(msqlConn *c, Tcl_Interp *interp,
			 int argc, char **argv);
extern int MSQL_Cmd_Set(msqlConn *c, Tcl_Interp *interp,
		       int argc, char **argv);
extern int MSQL_Cmd_Get(msqlConn *c, Tcl_Interp *interp,
		       int argc, char **argv);
extern int MSQL_Cmd_Query(msqlConn *c, Tcl_Interp *interp,
			 int argc, char **argv);
