/*
 *	tclStruct package
 *  Support 'C' structures in Tcl
 *
 *  Written by Matthew Costello
 *  (c) 1995 AT&T Global Information Solutions, Dayton Ohio USA
 *
 *  See the file "license.terms" for information on usage and
 *  redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */
#ifndef STRUCT_VERSION

#ifndef lint
static char struct_headerID[] = "@(#)tclStruct:tclStruct.h	1.9	95/09/12";
#endif


#define STRUCT_VERSION		"1.2"
#define STRUCT_MAJOR_VERSION	1
#define STRUCT_MINOR_VERSION	2

/*
 *  Our 'object's (or structures) are all known by the following
 *  Struct_Object.
 */
typedef struct Struct_Object {
	unsigned int	magic;  /* magic number */
	void *		data;	/* actual data */
	unsigned int	size;	/* data size (used for read/write & control) */
	struct Struct_TypeDef *type;	/* type of object */
} Struct_Object;


/*
 *  This structure is used to hold a type defintion.
 *  Named type definitions (typedef's) are
 *  stored in a Tcl hash table, with one typedef hash
 *  table per interpreter.
 */
typedef struct Struct_TypeDef {
	unsigned int	magic;  /* magic number */
	char *		name;		/* name of type (for debug) */
	int		refcount;	/* reference count */
	int		size;		/* the size of the type */
	int		align;		/* alignment restrictions */
	int		flags;
	char *		fill;		/* fill character or int */
	union {
	 struct {	/*STRUCT_FLAG_IS_ARRAY*/
	    struct Struct_TypeDef *array_elem;	/* type of array element */
	    char *		fill;		/* fill character or int */
	 } a;	/* Array */
	 struct {	/*STRUCT_FLAG_IS_STRUCT*/
	    struct Struct_StructElem *struct_def;
	    int		num_elements;	/* number of structure elements */
	 } s;	/* Struct */
	 struct {	/*STRUCT_FLAG_IS_POINTER*/
	    struct Struct_TypeDef *array_elem;	/* typedef of array element */
	 } p;	/* Pointer */
	 struct {	/*STRUCT_FLAG_NONE*/
	    int dummy;
	 } b;	/* Builtin type (handled by TraceProc) */
	} u;
	Tcl_VarTraceProc *TraceProc; /* tcl trace proc to be called for reading/writing this type */
} Struct_TypeDef;

#define STRUCT_FLAG_NONE	0
#define	STRUCT_FLAG_IS_BUILTIN	0x0000	/* default type is "builtin" */
#define STRUCT_FLAG_IS_ARRAY	0x0001
#define STRUCT_FLAG_IS_STRUCT	0x0002
#define STRUCT_FLAG_IS_POINTER	0x0004
#define STRUCT_FLAG_IS_ADDR	0x0008	/* special for _addr_ only! */
#define STRUCT_FLAG_IS_MASK	0x000f	/* kind of types (at 'C' level) */

	/* Passed to Struct_NewType */
#define STRUCT_FLAG_ALIGN_SIZE	0x00000100	/* align element to size */
#define STRUCT_FLAG_TRACE_ARRAY	0x00000200	/* trace works on arrays */
#define STRUCT_FLAG_TRACE_BASIC	0x00000400	/* indivisible trace function */
	/* Used internally */
#define STRUCT_FLAG_RECURSIVE	0x00000800	/* recurse definition */

	/* What features of a type may be set */
#define STRUCT_FLAG_USE_FILL	0x00001000	/* Fill string may be set */
#define STRUCT_FLAG_USE_STRICT	0x00002000	/* Uses STRICT flag */
#define STRUCT_FLAG_USE_NULLOK	0x00004000	/* Uses NULL_OK flag */
#define STRUCT_FLAG_USE_SIGN	0x00008000
/* #define STRUCT_FLAG_USE_JUST	0x00010000	*/
#define STRUCT_FLAG_USE_ENDIAN	0x00040000	/* Type cares about Endian */

#define STRUCT_FLAG_BUILTIN	0x00100000
#define STRUCT_FLAG_STRICT	0x00200000	/* perform strict checking */
#define STRUCT_FLAG_NULL_OK	0x00400000	/* NULL values are okay */
#define STRUCT_FLAG_UNSIGNED	0x00800000	/* number is unsigned */
#define STRUCT_FLAG_BIG_ENDIAN	0x04000000	/* Type is BIG endian */
#define STRUCT_FLAG_VARLEN	0x08000000	/* variable length type */

#define STRUCT_FLAG_JUST_NONE   0x00000000
#define STRUCT_FLAG_JUST_LEFT   0x01000000
#define STRUCT_FLAG_JUST_RIGHT  0x02000000
#define STRUCT_FLAG_JUST_CENTER 0x03000000
#define STRUCT_FLAG_JUST_MASK	0x03000000

/*  For structures, each element of a structure is defined
 *  by this array.
 */
typedef struct Struct_StructElem {
	char *			name;
	Struct_TypeDef		*type;
	int			offset;
} Struct_StructElem;

#define STRUCT_MAGIC_OBJECT	((unsigned int)0xfe0781ff)
#define STRUCT_MAGIC_TYPE	((unsigned int)0xfe0782ff)
#define STRUCT_MAGIC_COBJECT	((unsigned int)0xfe0783ff)


/*
 *  Exported tclStruct procedures:
 */

EXTERN CONST char *	Struct_AccessElement _ANSI_ARGS_((Tcl_Interp *,
				Struct_Object *,char*));
EXTERN void		Struct_AttachType _ANSI_ARGS_((Struct_TypeDef *));
EXTERN	Struct_TypeDef *	Struct_CloneType _ANSI_ARGS_((ClientData,
				Tcl_Interp *, const char *, Struct_TypeDef *));
EXTERN Struct_TypeDef *	Struct_DefArray _ANSI_ARGS_((ClientData,
				Tcl_Interp *, Struct_TypeDef *, int));
EXTERN int		Struct_DefType _ANSI_ARGS_((ClientData,
				Tcl_Interp *, CONST char *,char *));
EXTERN void		Struct_DeleteObject _ANSI_ARGS_((Struct_Object *));
EXTERN CONST char *	Struct_GenerateName _ANSI_ARGS_((const char *));
EXTERN ClientData	Struct_GetClientData _ANSI_ARGS_((Tcl_Interp *));
EXTERN int		Struct_GetObject _ANSI_ARGS_((Tcl_Interp *,
				const char*,Struct_Object *));
EXTERN int		Struct_GetObjectAndCheck _ANSI_ARGS_((Tcl_Interp *,
				const char*,const char *,Struct_Object *));
EXTERN int		Struct_Init _ANSI_ARGS_((Tcl_Interp *));
EXTERN Struct_TypeDef *	Struct_LookupType _ANSI_ARGS_((ClientData,
				Tcl_Interp *,const char *typename));
EXTERN Struct_TypeDef *	Struct_NewType _ANSI_ARGS_((ClientData,
				Tcl_Interp *, const char *, int, int,
				Tcl_VarTraceProc *));
EXTERN Struct_Object *	Struct_NewObject _ANSI_ARGS_((Struct_TypeDef *,
				void *,int,int));
EXTERN int		Struct_RegisterBuiltInType _ANSI_ARGS_((ClientData, 
				Tcl_Interp *, const char *, int, int, 
				Tcl_VarTraceProc *));
EXTERN int		Struct_RegisterType _ANSI_ARGS_((ClientData, 
				Tcl_Interp *, const char *, Struct_TypeDef *));
EXTERN void		Struct_ReleaseType _ANSI_ARGS_((Struct_TypeDef *));

#endif /*STRUCT_VERSION*/
