#!/usr/local/bin/tclsh
#	"@(#)tclStruct:fsinfo.tcl	1.1	95/10/17"
#
# Written by Matthew Costello
# (c) 1995 AT&T Global Information Solutions, Dayton Ohio USA
#
# See the file "license.terms" for information on usage and
# redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.

#	fsinfo.tcl [-server servername]
# This is a (partial) implementation of the fsinfo(1) command:
#	fsinfo is a utility for displaying information about an X
#	font server.  It is used to examine the capabilities of a
#	server, the predefined values for various parameters used in
#	communicating between clients and the server, and the font
#	catalogues and alternate servers that are available.
#

# Load the required extensions
load libdplite.so Tdp
load libtclStruct.so Struct

# Determine where the font server is located
catch {set fontserver $env(FONTSERVER)}
if {[string compare [lindex $argv 0] "-server"] == 0} {
	set fontserver [lindex $argv 1]
	incr argc -2
}
if {$argc != 0} {
	puts stderr "Usage: $argv0 \[-server servername\]"
	exit 2
}
if {[catch {set fs [split $fontserver : ]}]} {
	puts stderr "$argv0: FONTSERVER not set"
	exit 2
}
if {[llength $fs] != 2} {
	puts stderr "$argv0: FONTSERVER should have format 'server:port'"
	exit 2
}

# Connect to the font server
#puts "name of server: $fontserver"
set fd [eval dp_connect $fs]
#puts "$argv0:  unable to open server "
set fd [lindex $fd 0]
puts "name of server: $fontserver"

# Font server data types
struct_typedef request_packet {struct
	{ubyte	major_opcode}
	{ubyte	minor_opcode}
	{ushort	length}
}
struct_typedef reply_packet {struct
	{ubyte	type}
	{ubyte	data}
	{ushort	sequence}
	{uint	length}
}

set fs_statusSuccess	0
set fs_statusContinue	1
set fs_statusBusy	2
set fs_statusDenied	3


struct_typedef fs_open_connection_t {struct
	align 1
	{char	byte-order}
	{ubyte	num-auths}
	{ushort	client-major-protocol-version}
	{ushort	client-minor-protocol-version}
	{ushort	auth-len}
	{ubyte*0	authorization-protocols}
	align 4
}
struct_typedef fs_open_connection_setup_t {struct
	{ushort	status}
	{ushort	server-major-protocol-version}
	{ushort server-minor-protocol-version}
	{ubyte	num_alternates}
	{ubyte	auth_index}
	{ushort	alternate_len}
	{ushort	auth_len}
	{ubyte*0	data}
}
struct_typedef fs_open_connection_setup2_t {struct
	{uint	remaining-length}
	{ushort	maximum-request-length}
	{ushort	vendor-length}
	{uint	release-number}
	{char*0	vendor}
}

# Send the open connection request
struct_new open_connection fs_open_connection_t(0)
set open_connection() { l 0 2 0 }
struct_write -unbuffered $fd open_connection


struct_new connection_setup fs_open_connection_setup_t(0)
set rlen [struct_read -unbuffered $fd connection_setup]
puts "version number: $connection_setup(server-major-protocol-version)"
if {$connection_setup(status) != 0} {
	puts "$0: server did not accept connection ($connection_setup(status))"
	exit 1
}

struct_new connection_accept fs_open_connection_setup2_t(0)
set rlen [struct_read -unbuffered $fd connection_accept]


struct_typedef vendor_name1_t char*$connection_accept(vendor-length)
struct_typedef vendor_name2_t {struct {vendor_name1_t vendor_name} align 4}
struct_new vendor_name vendor_name2_t
set rlen [struct_read -unbuffered $fd vendor_name]
puts "vendor string:  $vendor_name(vendor_name)"

puts "vendor release number:  $connection_accept(release-number)"
puts "maximum request size:   $connection_accept(maximum-request-length) longwords ([expr $connection_accept(maximum-request-length) * 4] bytes)"

# Request list of catalogs
struct_typedef fs_list_catalogues_t {struct
	{ubyte	major-opcode}
	{ubyte	minor_opcode}
	{ushort	length}
	{uint	max-names}
	{ushort	pattern-length}
	{ushort {}}
	{char*0 pattern}
	align 4
}
struct_new list_catalogues fs_list_catalogues_t(1)
set list_catalogues() {3 0 4 99999 1 "*"}
set list_catalogues(length) [expr [struct_info sizeof list_catalogues] / 4]
struct_write -unbuffered $fd list_catalogues

struct_typedef fs_list_catalogues_reply_t {struct
	{ubyte	type}
	{ubyte	pad}
	{ushort	sequence-number}
	{uint	length}
	{uint	num-replies}
	{uint	num-catalogues}
}
	# LISTofSTRNAME
struct_new list_catalogues_reply fs_list_catalogues_reply_t
set rlen [struct_read -unbuffered $fd list_catalogues_reply]
#struct_dump list_catalogues_reply
puts "number of catalogues:   $list_catalogues_reply(num-catalogues)"

struct_new buffer byte*200
set rlen [struct_read -unbuffered $fd buffer [expr ( $list_catalogues_reply(length) - 4 ) * 4]]
for {set i 0 ; set count $list_catalogues_reply(num-catalogues)} {$count > 0} {incr count -1} {
	set len $buffer($i._ubyte_)
	#puts "i = $i, len = $len"
	incr i 1
	puts "\t$buffer(_char_.$i-[expr $i + $len])"
	incr i $len
}


puts "Number of alternate servers: $connection_setup(num_alternates)"
# TODO: list the alternate servers

#puts "number of extensions:   $connection_setup(num_alternates)"
# TODO: list the extensions


# Close connection to server
close $fd
