#	"@(#)tclStruct:first.tcl	1.1	95/10/17"
#
# Written by Matthew Costello
# (c) 1995 AT&T Global Information Solutions, Dayton Ohio USA
#
# See the file "license.terms" for information on usage and
# redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.

# This file was part of my original test suite.
# It is still useful as a way to demonstrate all the different
# ways to access the parts of an object.

puts {Testing the use of 'struct' with Tcl
}

set intrinsic [struct_info types]

puts {
    Sizes of types}
foreach type $intrinsic {
	puts "Size of $type is [struct_info sizeof $type]"
}

puts ""
puts {Defining structure ...
    struct_typedef combined {struct
	{int anint}
	{ushort ashort}
	{char achar1}
	{char achar2}
	{^short aptr}
    }}
struct_typedef combined {struct
	{int anint}
	{ushort ashort}
	{char achar1}
	{char achar2}
	{^short aptr}
}
puts "Display size ..."
puts "Size of combined is [struct_info sizeof combined]"

puts "Allocate object"
puts [struct_new obj combined]
puts "okay"
foreach elem {aptr aptr._hex_ {}} {
	puts "  obj($elem) = '$obj($elem)'"
}

puts "Size of obj is [struct_info sizeof obj]"
puts "Size of combined is [struct_info sizeof combined]"
set obj(_char_) {ABCDEFGHIJKL}

foreach elem {{} _hex_ anint ashort achar1 achar2 ashort._hex_ achar2._hex_ ashort._char_ _char_} {
	puts "  obj($elem) = '$obj($elem)'"
}

puts ""
# struct_typedef linebuf char*32
struct_new linebuf char*32
foreach elem {_hex_ 2 2._hex_} {
	puts "  linebuf($elem) = '$linebuf($elem)'"
}

puts "  obj() = '$obj()'"

struct_typedef link1 {struct {^link1 next} {int count}}

# exit
