/******************************************************************************
*                                                                             *
* Copyright (c) 1991,							      *
* 	National Center for Atmospheric Research                              *
*                                                                             *
******************************************************************************/
    
#if !defined(lint) && !defined(VX)
static char rcsid[]=
"$Header: /usr/local/source/coda_source/Tcl/src7.4/tcl7.4/vxCompat.c,v 1.1.1.1 1996/08/21 19:30:17 heyes Exp $";
#endif
#include <vxWorks.h>

/*
 * compatability routines for Unix code
 */
#include "tclInt.h"
#include "tclPort.h"


#ifdef NEED_ACCESS	/* now found in softclock/stubs.c */
/*
 * a very limited implementation of the Unix system call,
 * sufficient for use by TCL
 */
int
access(char *name, int mode)
{
    int fd;
    
    switch (mode)
    {
	case R_OK:
	    if ((fd = open(name, O_RDONLY, 0)) < 0) 
	    {
		return(-1);
	    }
	    (void) close(fd);
	    break;
	case W_OK:
	    if ((fd = open(name, O_WRONLY, 0)) < 0) 
	    {
		return(-1);
	    }
	    (void) close(fd);
	    break;
	default:
	    return(-1);
    }
    return(0);
}
#endif

/*****************************************************
 * hostname
 *
 * Provided to implement the unix "hostname" command.
 * In this case, host refers to the vxWorks target on
 * which this command is implemented.
 *****************************************************/

#include <bootLib.h>
#include <sysLib.h>

void
hostname()
{
    fprintf(stdout, "%s\n", sysBootParams.targetName);
    return;
}

/*
 * provided time in ticks for timing purposes
 */
 
#include <tickLib.h>

int
times(struct tms *dummy)
{
    return(tickGet());
}

#ifdef NOTDEF
abort()
{
    logMsg ("abort called - task suspended\n");
    taskSuspend(0);
}
#endif
    
/******************************************************************************
* Revision history:                                                           *
* $Log: vxCompat.c,v $
* Revision 1.1.1.1  1996/08/21 19:30:17  heyes
* Imported sources
*
 * Revision 1.1  1993/11/02  20:21:04  vanandel
 * Initial revision
 *
*                                                                             *
*********************************END OF RCS INFO******************************/


